/*
 * Decompiled with CFR 0.152.
 */
package com.eureka2.shading.apache.avro;

import com.eureka2.shading.apache.avro.AvroRuntimeException;
import com.eureka2.shading.apache.avro.SchemaValidationStrategy;
import com.eureka2.shading.apache.avro.SchemaValidator;
import com.eureka2.shading.apache.avro.ValidateAll;
import com.eureka2.shading.apache.avro.ValidateCanBeRead;
import com.eureka2.shading.apache.avro.ValidateCanRead;
import com.eureka2.shading.apache.avro.ValidateLatest;
import com.eureka2.shading.apache.avro.ValidateMutualRead;

public final class SchemaValidatorBuilder {
    private SchemaValidationStrategy strategy;

    public SchemaValidatorBuilder strategy(SchemaValidationStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public SchemaValidatorBuilder canReadStrategy() {
        this.strategy = new ValidateCanRead();
        return this;
    }

    public SchemaValidatorBuilder canBeReadStrategy() {
        this.strategy = new ValidateCanBeRead();
        return this;
    }

    public SchemaValidatorBuilder mutualReadStrategy() {
        this.strategy = new ValidateMutualRead();
        return this;
    }

    public SchemaValidator validateLatest() {
        this.valid();
        return new ValidateLatest(this.strategy);
    }

    public SchemaValidator validateAll() {
        this.valid();
        return new ValidateAll(this.strategy);
    }

    private void valid() {
        if (null == this.strategy) {
            throw new AvroRuntimeException("SchemaValidationStrategy not specified in builder");
        }
    }
}

