/*
 * Decompiled with CFR 0.152.
 */
package com.eureka2.shading.codehaus.jackson.map.deser.std;

import com.eureka2.shading.codehaus.jackson.JsonParser;
import com.eureka2.shading.codehaus.jackson.JsonProcessingException;
import com.eureka2.shading.codehaus.jackson.map.DeserializationContext;
import com.eureka2.shading.codehaus.jackson.map.annotate.JacksonStdImpl;
import com.eureka2.shading.codehaus.jackson.map.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class CalendarDeserializer
extends StdScalarDeserializer<Calendar> {
    protected final Class<? extends Calendar> _calendarClass;

    public CalendarDeserializer() {
        this((Class<? extends Calendar>)null);
    }

    public CalendarDeserializer(Class<? extends Calendar> cc) {
        super(Calendar.class);
        this._calendarClass = cc;
    }

    @Override
    public Calendar deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Date d = this._parseDate(jp, ctxt);
        if (d == null) {
            return null;
        }
        if (this._calendarClass == null) {
            return ctxt.constructCalendar(d);
        }
        try {
            Calendar c = this._calendarClass.newInstance();
            c.setTimeInMillis(d.getTime());
            return c;
        }
        catch (Exception e) {
            throw ctxt.instantiationException(this._calendarClass, e);
        }
    }
}

