/*
 * Decompiled with CFR 0.152.
 */
package com.eureka2.shading.reactivex.netty.client;

import com.eureka2.shading.reactivex.netty.RxNetty;
import com.eureka2.shading.reactivex.netty.channel.ObservableConnection;
import com.eureka2.shading.reactivex.netty.client.AbstractClientBuilder;
import com.eureka2.shading.reactivex.netty.client.ClientChannelFactory;
import com.eureka2.shading.reactivex.netty.client.ClientChannelFactoryImpl;
import com.eureka2.shading.reactivex.netty.client.ClientConnectionFactory;
import com.eureka2.shading.reactivex.netty.client.ClientMetricsEvent;
import com.eureka2.shading.reactivex.netty.client.ConnectionPoolBuilder;
import com.eureka2.shading.reactivex.netty.client.RxClient;
import com.eureka2.shading.reactivex.netty.client.RxClientImpl;
import com.eureka2.shading.reactivex.netty.client.UnpooledClientConnectionFactory;
import com.eureka2.shading.reactivex.netty.metrics.MetricEventsListener;
import com.eureka2.shading.reactivex.netty.metrics.MetricEventsListenerFactory;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.SocketChannel;

public class ClientBuilder<I, O>
extends AbstractClientBuilder<I, O, ClientBuilder<I, O>, RxClient<I, O>> {
    public ClientBuilder(String host, int port) {
        this(host, port, new Bootstrap());
    }

    public ClientBuilder(String host, int port, Bootstrap bootstrap) {
        super(bootstrap, host, port, new UnpooledClientConnectionFactory(), new ClientChannelFactoryImpl(bootstrap));
        this.defaultTcpOptions();
    }

    public ClientBuilder(Bootstrap bootstrap, String host, int port, ClientConnectionFactory<O, I, ? extends ObservableConnection<O, I>> connectionFactory, ClientChannelFactory<O, I> factory) {
        super(bootstrap, host, port, connectionFactory, factory);
    }

    public ClientBuilder(Bootstrap bootstrap, String host, int port, ConnectionPoolBuilder<O, I> poolBuilder) {
        super(bootstrap, host, port, poolBuilder);
    }

    @Override
    protected RxClient<I, O> createClient() {
        if (null == this.poolBuilder) {
            return new RxClientImpl(this.getOrCreateName(), this.serverInfo, this.bootstrap, this.pipelineConfigurator, this.clientConfig, this.channelFactory, this.connectionFactory, this.eventsSubject);
        }
        return new RxClientImpl(this.getOrCreateName(), this.serverInfo, this.bootstrap, this.pipelineConfigurator, this.clientConfig, this.poolBuilder, this.eventsSubject);
    }

    @Override
    protected String generatedNamePrefix() {
        return "TcpClient-";
    }

    @Override
    protected Class<? extends SocketChannel> defaultSocketChannelClass() {
        if (RxNetty.isUsingNativeTransport()) {
            return EpollSocketChannel.class;
        }
        return super.defaultSocketChannelClass();
    }

    @Override
    protected EventLoopGroup defaultEventloop(Class<? extends Channel> socketChannel) {
        return RxNetty.getRxEventLoopProvider().globalClientEventLoop(true);
    }

    @Override
    protected MetricEventsListener<? extends ClientMetricsEvent<ClientMetricsEvent.EventType>> newMetricsListener(MetricEventsListenerFactory factory, RxClient<I, O> client) {
        return factory.forTcpClient(client);
    }
}

