/*
 * Decompiled with CFR 0.152.
 */
package com.eureka2.shading.reactivex.netty.protocol.http.client;

import com.eureka2.shading.reactivex.netty.RxNetty;
import com.eureka2.shading.reactivex.netty.channel.ObservableConnection;
import com.eureka2.shading.reactivex.netty.client.AbstractClientBuilder;
import com.eureka2.shading.reactivex.netty.client.ClientChannelFactory;
import com.eureka2.shading.reactivex.netty.client.ClientChannelFactoryImpl;
import com.eureka2.shading.reactivex.netty.client.ClientConnectionFactory;
import com.eureka2.shading.reactivex.netty.client.ClientMetricsEvent;
import com.eureka2.shading.reactivex.netty.client.ConnectionPoolBuilder;
import com.eureka2.shading.reactivex.netty.client.UnpooledClientConnectionFactory;
import com.eureka2.shading.reactivex.netty.metrics.MetricEventsListener;
import com.eureka2.shading.reactivex.netty.metrics.MetricEventsListenerFactory;
import com.eureka2.shading.reactivex.netty.metrics.MetricEventsSubject;
import com.eureka2.shading.reactivex.netty.pipeline.PipelineConfigurators;
import com.eureka2.shading.reactivex.netty.protocol.http.client.HttpClient;
import com.eureka2.shading.reactivex.netty.protocol.http.client.HttpClientImpl;
import com.eureka2.shading.reactivex.netty.protocol.http.client.HttpClientRequest;
import com.eureka2.shading.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.SocketChannel;

public class HttpClientBuilder<I, O>
extends AbstractClientBuilder<HttpClientRequest<I>, HttpClientResponse<O>, HttpClientBuilder<I, O>, HttpClient<I, O>> {
    public HttpClientBuilder(String host, int port) {
        this(host, port, new Bootstrap());
    }

    public HttpClientBuilder(String host, int port, Bootstrap bootstrap) {
        this(bootstrap, host, port, (ClientConnectionFactory<HttpClientResponse<O>, HttpClientRequest<I>, ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>>)new UnpooledClientConnectionFactory<HttpClientResponse<O>, HttpClientRequest<I>>(), (ClientChannelFactory<HttpClientResponse<O>, HttpClientRequest<I>>)new ClientChannelFactoryImpl<HttpClientResponse<O>, HttpClientRequest<I>>(bootstrap));
    }

    public HttpClientBuilder(Bootstrap bootstrap, String host, int port, ClientConnectionFactory<HttpClientResponse<O>, HttpClientRequest<I>, ? extends ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> connectionFactory, ClientChannelFactory<HttpClientResponse<O>, HttpClientRequest<I>> factory) {
        super(bootstrap, host, port, connectionFactory, factory);
        this.clientConfig = HttpClient.HttpClientConfig.Builder.newDefaultConfig();
        this.pipelineConfigurator(PipelineConfigurators.httpClientConfigurator());
    }

    public HttpClientBuilder(Bootstrap bootstrap, String host, int port, ConnectionPoolBuilder<HttpClientResponse<O>, HttpClientRequest<I>> poolBuilder) {
        super(bootstrap, host, port, poolBuilder);
        this.clientConfig = HttpClient.HttpClientConfig.Builder.newDefaultConfig();
        this.pipelineConfigurator(PipelineConfigurators.httpClientConfigurator());
    }

    @Override
    protected Class<? extends SocketChannel> defaultSocketChannelClass() {
        if (RxNetty.isUsingNativeTransport()) {
            return EpollSocketChannel.class;
        }
        return super.defaultSocketChannelClass();
    }

    @Override
    protected EventLoopGroup defaultEventloop(Class<? extends Channel> socketChannel) {
        return RxNetty.getRxEventLoopProvider().globalClientEventLoop(true);
    }

    @Override
    protected HttpClient<I, O> createClient() {
        if (null == this.poolBuilder) {
            return new HttpClientImpl(this.getOrCreateName(), this.serverInfo, this.bootstrap, this.pipelineConfigurator, this.clientConfig, this.channelFactory, this.connectionFactory, (MetricEventsSubject<ClientMetricsEvent<?>>)this.eventsSubject);
        }
        return new HttpClientImpl(this.getOrCreateName(), this.serverInfo, this.bootstrap, this.pipelineConfigurator, this.clientConfig, this.poolBuilder, (MetricEventsSubject<ClientMetricsEvent<?>>)this.eventsSubject);
    }

    @Override
    protected String generatedNamePrefix() {
        return "HttpClient-";
    }

    @Override
    protected MetricEventsListener<? extends ClientMetricsEvent<?>> newMetricsListener(MetricEventsListenerFactory factory, HttpClient<I, O> client) {
        return factory.forHttpClient(client);
    }
}

