/*
 * Decompiled with CFR 0.152.
 */
package com.eureka2.shading.reactivex.netty.protocol.http.client;

import com.eureka2.shading.reactivex.netty.channel.ObservableConnection;
import com.eureka2.shading.reactivex.netty.client.ClientChannelFactory;
import com.eureka2.shading.reactivex.netty.client.ClientConnectionFactory;
import com.eureka2.shading.reactivex.netty.client.ClientMetricsEvent;
import com.eureka2.shading.reactivex.netty.client.ConnectionPool;
import com.eureka2.shading.reactivex.netty.client.ConnectionPoolBuilder;
import com.eureka2.shading.reactivex.netty.client.RxClient;
import com.eureka2.shading.reactivex.netty.client.RxClientImpl;
import com.eureka2.shading.reactivex.netty.metrics.Clock;
import com.eureka2.shading.reactivex.netty.metrics.MetricEventsSubject;
import com.eureka2.shading.reactivex.netty.pipeline.PipelineConfigurator;
import com.eureka2.shading.reactivex.netty.pipeline.PipelineConfiguratorComposite;
import com.eureka2.shading.reactivex.netty.protocol.http.client.ClientRequiredConfigurator;
import com.eureka2.shading.reactivex.netty.protocol.http.client.HttpClient;
import com.eureka2.shading.reactivex.netty.protocol.http.client.HttpClientMetricsEvent;
import com.eureka2.shading.reactivex.netty.protocol.http.client.HttpClientRequest;
import com.eureka2.shading.reactivex.netty.protocol.http.client.HttpClientResponse;
import com.eureka2.shading.reactivex.netty.protocol.http.client.RedirectOperator;
import com.eureka2.shading.reactivex.netty.protocol.http.client.RequestProcessingOperator;
import io.netty.bootstrap.Bootstrap;
import io.netty.handler.codec.http.HttpMethod;
import rx.Observable;
import rx.functions.Action0;

public class HttpClientImpl<I, O>
extends RxClientImpl<HttpClientRequest<I>, HttpClientResponse<O>>
implements HttpClient<I, O> {
    private final String hostHeaderValue = this.prepareHostHeaderValue();

    public HttpClientImpl(String name, RxClient.ServerInfo serverInfo, Bootstrap clientBootstrap, PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> pipelineConfigurator, RxClient.ClientConfig clientConfig, ClientChannelFactory<HttpClientResponse<O>, HttpClientRequest<I>> channelFactory, ClientConnectionFactory<HttpClientResponse<O>, HttpClientRequest<I>, ? extends ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> connectionFactory, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        super(name, serverInfo, clientBootstrap, pipelineConfigurator, clientConfig, channelFactory, connectionFactory, eventsSubject);
    }

    public HttpClientImpl(String name, RxClient.ServerInfo serverInfo, Bootstrap clientBootstrap, PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> pipelineConfigurator, RxClient.ClientConfig clientConfig, ConnectionPoolBuilder<HttpClientResponse<O>, HttpClientRequest<I>> poolBuilder, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        super(name, serverInfo, clientBootstrap, pipelineConfigurator, clientConfig, poolBuilder, eventsSubject);
    }

    @Override
    public Observable<HttpClientResponse<O>> submit(HttpClientRequest<I> request) {
        return this.submit(request, this.connect());
    }

    @Override
    public Observable<HttpClientResponse<O>> submit(HttpClientRequest<I> request, RxClient.ClientConfig config) {
        return this.submit(request, this.connect(), config);
    }

    protected Observable<HttpClientResponse<O>> submit(HttpClientRequest<I> request, Observable<ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> connectionObservable) {
        return this.submit(request, connectionObservable, null == this.clientConfig ? HttpClient.HttpClientConfig.Builder.newDefaultConfig() : this.clientConfig);
    }

    protected Observable<HttpClientResponse<O>> submit(HttpClientRequest<I> request, Observable<ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> connectionObservable, RxClient.ClientConfig config) {
        final long startTimeMillis = Clock.newStartTimeMillis();
        HttpClient.HttpClientConfig httpClientConfig = config instanceof HttpClient.HttpClientConfig ? (HttpClient.HttpClientConfig)config : new HttpClient.HttpClientConfig(config);
        boolean followRedirect = this.shouldFollowRedirectForRequest(httpClientConfig, request);
        this.enrichRequest(request, httpClientConfig);
        Observable toReturn = connectionObservable.lift(new RequestProcessingOperator(request, this.eventsSubject, httpClientConfig.getResponseSubscriptionTimeoutMs()));
        if (followRedirect) {
            toReturn = toReturn.lift(new RedirectOperator(request, this, httpClientConfig));
        }
        return toReturn.take(1).finallyDo(new Action0(){

            public void call() {
                HttpClientImpl.this.eventsSubject.onEvent(HttpClientMetricsEvent.REQUEST_PROCESSING_COMPLETE, Clock.onEndMillis(startTimeMillis));
            }
        });
    }

    @Override
    protected PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> adaptPipelineConfigurator(PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> pipelineConfigurator, RxClient.ClientConfig clientConfig, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        PipelineConfiguratorComposite configurator = new PipelineConfiguratorComposite(pipelineConfigurator, new ClientRequiredConfigurator(eventsSubject));
        return super.adaptPipelineConfigurator(configurator, clientConfig, eventsSubject);
    }

    protected boolean shouldFollowRedirectForRequest(HttpClient.HttpClientConfig config, HttpClientRequest<I> request) {
        HttpClient.HttpClientConfig.RedirectsHandling redirectsHandling = config.getFollowRedirect();
        switch (redirectsHandling) {
            case Enable: {
                return true;
            }
            case Disable: {
                return false;
            }
            case Undefined: {
                return request.getMethod() == HttpMethod.HEAD || request.getMethod() == HttpMethod.GET;
            }
        }
        return false;
    }

    ConnectionPool<HttpClientResponse<O>, HttpClientRequest<I>> getConnectionPool() {
        return this.pool;
    }

    private void enrichRequest(HttpClientRequest<I> request, RxClient.ClientConfig config) {
        HttpClient.HttpClientConfig httpClientConfig;
        request.setDynamicUriParts(this.serverInfo.getHost(), this.serverInfo.getPort(), false);
        if (!request.getHeaders().contains("Host")) {
            request.getHeaders().add("Host", (Object)this.hostHeaderValue);
        }
        if (config instanceof HttpClient.HttpClientConfig && (httpClientConfig = (HttpClient.HttpClientConfig)config).getUserAgent() != null && request.getHeaders().get("User-Agent") == null) {
            request.getHeaders().set("User-Agent", (Object)httpClientConfig.getUserAgent());
        }
    }

    private String prepareHostHeaderValue() {
        if (this.serverInfo.getPort() == 80 || this.serverInfo.getPort() == 443) {
            return this.serverInfo.getHost();
        }
        return this.serverInfo.getHost() + ':' + this.serverInfo.getPort();
    }
}

