/*
 * Decompiled with CFR 0.152.
 */
package com.eureka2.shading.reactivex.netty.protocol.http.client;

import com.eureka2.shading.reactivex.netty.protocol.http.client.DefaultRedirectHandler;
import com.eureka2.shading.reactivex.netty.protocol.http.client.HttpClient;
import com.eureka2.shading.reactivex.netty.protocol.http.client.HttpClientRequest;
import com.eureka2.shading.reactivex.netty.protocol.http.client.HttpClientResponse;
import com.eureka2.shading.reactivex.netty.protocol.http.client.HttpRedirectException;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.subscriptions.SerialSubscription;

public class RedirectOperator<I, O>
implements Observable.Operator<HttpClientResponse<O>, HttpClientResponse<O>> {
    public static final int DEFAULT_MAX_HOPS = 5;
    private final HttpClientRequest<I> originalRequest;
    private final RedirectHandler<I, O> redirectHandler;
    private final HttpClient.HttpClientConfig clientConfig;

    public RedirectOperator(HttpClientRequest<I> originalRequest, int maxHops, HttpClient<I, O> clientForRedirect) {
        this(originalRequest, new DefaultRedirectHandler<I, O>(maxHops, clientForRedirect));
    }

    public RedirectOperator(HttpClientRequest<I> originalRequest, HttpClient<I, O> clientForRedirect, HttpClient.HttpClientConfig config) {
        this(originalRequest, new DefaultRedirectHandler<I, O>(null == config ? 5 : config.getMaxRedirects(), clientForRedirect), config);
    }

    public RedirectOperator(HttpClientRequest<I> originalRequest, RedirectHandler<I, O> redirectHandler) {
        this(originalRequest, redirectHandler, null);
    }

    public RedirectOperator(HttpClientRequest<I> originalRequest, RedirectHandler<I, O> redirectHandler, HttpClient.HttpClientConfig clientConfig) {
        this.originalRequest = originalRequest;
        this.redirectHandler = redirectHandler;
        this.clientConfig = (HttpClient.HttpClientConfig)HttpClient.HttpClientConfig.Builder.from(clientConfig).setFollowRedirect(false).build();
    }

    public Subscriber<? super HttpClientResponse<O>> call(Subscriber<? super HttpClientResponse<O>> child) {
        SerialSubscription serialSubscription = new SerialSubscription();
        child.add((Subscription)serialSubscription);
        RedirectHandler.RedirectionContext redirectionContext = new RedirectHandler.RedirectionContext(this.originalRequest);
        RedirectSubscriber toReturn = new RedirectSubscriber(child, redirectionContext, serialSubscription, this.redirectHandler);
        serialSubscription.set((Subscription)toReturn);
        return toReturn;
    }

    private class RedirectSubscriber
    extends Subscriber<HttpClientResponse<O>> {
        private final Subscriber<? super HttpClientResponse<O>> child;
        private final RedirectHandler.RedirectionContext redirectionContext;
        private final SerialSubscription serialSubscription;
        private final RedirectHandler<I, O> redirectHandler;
        private final AtomicBoolean finished = new AtomicBoolean();
        private volatile boolean doRedirectOnNextComplete;

        public RedirectSubscriber(Subscriber<? super HttpClientResponse<O>> child, RedirectHandler.RedirectionContext redirectionContext, SerialSubscription serialSubscription, RedirectHandler<I, O> redirectHandler) {
            this.child = child;
            this.redirectionContext = redirectionContext;
            this.serialSubscription = serialSubscription;
            this.redirectHandler = redirectHandler;
        }

        public void onCompleted() {
            this.doRedirectIfRequired();
            if (!this.isUnsubscribed() && this.finished.compareAndSet(false, true)) {
                this.child.onCompleted();
            }
        }

        public void onError(Throwable e) {
            this.doRedirectIfRequired();
            if (!this.isUnsubscribed() && this.finished.compareAndSet(false, true)) {
                this.child.onError(e);
            }
        }

        public void onNext(HttpClientResponse<O> response) {
            if (this.isUnsubscribed() || this.finished.get()) {
                return;
            }
            if (this.redirectHandler.requiresRedirect(this.redirectionContext, response)) {
                try {
                    this.redirectHandler.validate(this.redirectionContext, response);
                    this.redirectionContext.setLastRedirectStatus(response.getStatus());
                    this.doRedirectOnNextComplete = true;
                }
                catch (HttpRedirectException e) {
                    this.onError(e);
                }
            } else {
                this.doRedirectOnNextComplete = false;
                this.child.onNext(response);
            }
        }

        private void doRedirectIfRequired() {
            if (this.doRedirectOnNextComplete && !this.finished.get()) {
                this.redirectionContext.onNewRedirect();
                Observable redirect = this.redirectHandler.doRedirect(this.redirectionContext, RedirectOperator.this.originalRequest, RedirectOperator.this.clientConfig);
                RedirectSubscriber newSub = this.copy();
                this.serialSubscription.set((Subscription)newSub);
                redirect.unsafeSubscribe((Subscriber)newSub);
            }
        }

        public RedirectSubscriber copy() {
            return new RedirectSubscriber(this.child, this.redirectionContext, this.serialSubscription, this.redirectHandler);
        }
    }

    public static interface RedirectHandler<I, O> {
        public Observable<HttpClientResponse<O>> doRedirect(RedirectionContext var1, HttpClientRequest<I> var2, HttpClient.HttpClientConfig var3);

        public boolean requiresRedirect(RedirectionContext var1, HttpClientResponse<O> var2);

        public void validate(RedirectionContext var1, HttpClientResponse<O> var2);

        public static class RedirectionContext {
            private final List<String> visitedLocations = new ArrayList<String>();
            private List<String> visitedLocationsImmutable;
            private volatile int redirectCount;
            private volatile URI nextRedirect;
            private volatile HttpResponseStatus lastRedirectStatus;

            public RedirectionContext(HttpClientRequest originalRequest) {
                String uri = originalRequest.getAbsoluteUri();
                this.visitedLocations.add(uri);
                this.visitedLocationsImmutable = Collections.unmodifiableList(this.visitedLocations);
                this.redirectCount = 0;
            }

            public void newLocation(String visitedLocation) {
                this.visitedLocations.add(visitedLocation);
                this.visitedLocationsImmutable = Collections.unmodifiableList(this.visitedLocations);
            }

            public List<String> getVisitedLocations() {
                return this.visitedLocationsImmutable;
            }

            void onNewRedirect() {
                ++this.redirectCount;
            }

            public int getRedirectCount() {
                return this.redirectCount;
            }

            public void setNextRedirect(URI nextRedirect) {
                this.nextRedirect = nextRedirect;
            }

            public URI getNextRedirect() {
                return this.nextRedirect;
            }

            public HttpResponseStatus getLastRedirectStatus() {
                return this.lastRedirectStatus;
            }

            public void setLastRedirectStatus(HttpResponseStatus lastRedirectStatus) {
                this.lastRedirectStatus = lastRedirectStatus;
            }
        }
    }
}

