/*
 * Decompiled with CFR 0.152.
 */
package com.eureka2.shading.reactivex.netty.protocol.http.server.file;

import com.eureka2.shading.reactivex.netty.protocol.http.server.ErrorResponseGenerator;
import com.eureka2.shading.reactivex.netty.protocol.http.server.HttpError;
import com.eureka2.shading.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpResponseStatus;
import rx.functions.Func1;

public class FileErrorResponseMapper
implements Func1<Throwable, ErrorResponseGenerator<ByteBuf>> {
    public static final String _404_HTML_TEMPLATE = "<!DOCTYPE html>\n<html>\n<head>\n    <title>Http Error 404</title>\n</head>\n<body>\n    <h1>File not found.</h1>\n</body>\n</html>";

    public ErrorResponseGenerator<ByteBuf> call(Throwable t1) {
        HttpError error;
        if (t1 instanceof HttpError && (error = (HttpError)t1).getStatus().equals((Object)HttpResponseStatus.NOT_FOUND)) {
            return new ConstantErrorResponseGenerator<ByteBuf>(_404_HTML_TEMPLATE);
        }
        return null;
    }

    private static class ConstantErrorResponseGenerator<O>
    implements ErrorResponseGenerator<O> {
        public final String template;

        public ConstantErrorResponseGenerator(String template) {
            this.template = template;
        }

        @Override
        public void updateResponse(HttpServerResponse<O> response, Throwable t) {
            HttpError error = (HttpError)t;
            response.setStatus(error.getStatus());
            response.getHeaders().set("Content-Type", (Object)"text/html");
            response.writeString(this.template);
        }
    }
}

