/*
 * Decompiled with CFR 0.152.
 */
package com.eureka2.shading.reactivex.netty.protocol.http.server.file;

import com.eureka2.shading.reactivex.netty.protocol.http.server.HttpError;
import com.eureka2.shading.reactivex.netty.protocol.http.server.HttpServerRequest;
import com.eureka2.shading.reactivex.netty.protocol.http.server.HttpServerResponse;
import com.eureka2.shading.reactivex.netty.protocol.http.server.file.AbstractFileRequestHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public abstract class FileRequestHandler
extends AbstractFileRequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(FileRequestHandler.class);
    private static final int CHUNK_SIZE = 8192;

    @Override
    public Observable<Void> handle(HttpServerRequest<ByteBuf> request, HttpServerResponse<ByteBuf> response) {
        long fileLength;
        if (!request.getHttpMethod().equals((Object)HttpMethod.GET)) {
            return Observable.error((Throwable)new HttpError(HttpResponseStatus.METHOD_NOT_ALLOWED));
        }
        RandomAccessFile raf = null;
        String sanitizedUri = FileRequestHandler.sanitizeUri(request.getUri());
        if (sanitizedUri == null) {
            return Observable.error((Throwable)new HttpError(HttpResponseStatus.FORBIDDEN));
        }
        URI uri = this.resolveUri(sanitizedUri);
        if (uri == null) {
            return Observable.error((Throwable)new HttpError(HttpResponseStatus.NOT_FOUND));
        }
        File file = new File(uri);
        if (file.isHidden() || !file.exists()) {
            return Observable.error((Throwable)new HttpError(HttpResponseStatus.NOT_FOUND));
        }
        if (file.isDirectory()) {
            return Observable.error((Throwable)new HttpError(HttpResponseStatus.FORBIDDEN));
        }
        if (!file.isFile()) {
            return Observable.error((Throwable)new HttpError(HttpResponseStatus.FORBIDDEN));
        }
        try {
            raf = new RandomAccessFile(file, "r");
            fileLength = raf.length();
        }
        catch (Exception e) {
            logger.warn("Error accessing file {}", (Object)uri, (Object)e);
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e1) {
                    logger.warn("Error closing file {}", (Object)uri, (Object)e1);
                }
            }
            return Observable.error((Throwable)e);
        }
        String ifModifiedSince = request.getHeaders().get("If-Modified-Since");
        if (ifModifiedSince != null && !ifModifiedSince.isEmpty()) {
            long fileLastModifiedSeconds;
            long ifModifiedSinceDateSeconds;
            SimpleDateFormat dateFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            Date ifModifiedSinceDate = null;
            try {
                ifModifiedSinceDate = dateFormatter.parse(ifModifiedSince);
            }
            catch (ParseException e) {
                logger.warn("Failed to parse {} header", (Object)"If-Modified-Since");
            }
            if (ifModifiedSinceDate != null && (ifModifiedSinceDateSeconds = ifModifiedSinceDate.getTime() / 1000L) == (fileLastModifiedSeconds = file.lastModified() / 1000L)) {
                response.setStatus(HttpResponseStatus.NOT_MODIFIED);
                FileRequestHandler.setDateHeader(response, dateFormatter);
                return response.close();
            }
        }
        response.setStatus(HttpResponseStatus.OK);
        response.getHeaders().setContentLength(fileLength);
        FileRequestHandler.setContentTypeHeader(response, file);
        FileRequestHandler.setDateAndCacheHeaders(response, file);
        if (request.getHeaders().isKeepAlive()) {
            response.getHeaders().set("Connection", (Object)"keep-alive");
        }
        if (response.getChannel().pipeline().get(SslHandler.class) == null) {
            response.writeFileRegion((FileRegion)new DefaultFileRegion(raf.getChannel(), 0L, fileLength));
        } else {
            try {
                response.writeChunkedInput(new HttpChunkedInput((ChunkedInput)new ChunkedFile(raf, 0L, fileLength, 8192)));
            }
            catch (IOException e) {
                logger.warn("Failed to write chunked file {}", (Throwable)e);
                return Observable.error((Throwable)e);
            }
        }
        return response.close();
    }

    protected abstract URI resolveUri(String var1);
}

