/*
 * Decompiled with CFR 0.152.
 */
package com.eureka2.shading.reactivex.netty.protocol.http.websocket;

import com.eureka2.shading.reactivex.netty.metrics.MetricEventsSubject;
import com.eureka2.shading.reactivex.netty.pipeline.PipelineConfigurator;
import com.eureka2.shading.reactivex.netty.protocol.http.websocket.WebSocketServerHandler;
import com.eureka2.shading.reactivex.netty.server.ServerMetricsEvent;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;

public class WebSocketServerPipelineConfigurator<R, W>
implements PipelineConfigurator<R, W> {
    private final String webSocketURI;
    private final String subprotocols;
    private final boolean allowExtensions;
    private final int maxFramePayloadLength;
    private final boolean messageAggregator;
    private MetricEventsSubject<ServerMetricsEvent<?>> eventsSubject;

    public WebSocketServerPipelineConfigurator(String webSocketURI, String subprotocols, boolean allowExtensions, int maxFramePayloadLength, boolean messageAggregator) {
        this.webSocketURI = webSocketURI;
        this.subprotocols = subprotocols;
        this.allowExtensions = allowExtensions;
        this.maxFramePayloadLength = maxFramePayloadLength;
        this.messageAggregator = messageAggregator;
    }

    @Override
    public void configureNewPipeline(ChannelPipeline pipeline) {
        WebSocketServerHandshakerFactory handshakeHandlerFactory = new WebSocketServerHandshakerFactory(this.webSocketURI, this.subprotocols, this.allowExtensions, this.maxFramePayloadLength);
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerHandler(handshakeHandlerFactory, this.maxFramePayloadLength, this.messageAggregator, this.eventsSubject)});
    }

    void useMetricEventsSubject(MetricEventsSubject<ServerMetricsEvent<?>> eventsSubject) {
        this.eventsSubject = eventsSubject;
    }
}

