/*
 * Decompiled with CFR 0.152.
 */
package com.eureka2.shading.reactivex.netty.server;

import com.eureka2.shading.reactivex.netty.RxNetty;
import com.eureka2.shading.reactivex.netty.channel.ConnectionHandler;
import com.eureka2.shading.reactivex.netty.server.AbstractServerBuilder;
import com.eureka2.shading.reactivex.netty.server.RxServer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;

public abstract class ConnectionBasedServerBuilder<I, O, B extends ConnectionBasedServerBuilder>
extends AbstractServerBuilder<I, O, ServerBootstrap, ServerChannel, B, RxServer<I, O>> {
    protected ConnectionBasedServerBuilder(int port, ConnectionHandler<I, O> connectionHandler) {
        this(port, connectionHandler, new ServerBootstrap());
    }

    protected ConnectionBasedServerBuilder(int port, ConnectionHandler<I, O> connectionHandler, ServerBootstrap bootstrap) {
        super(port, bootstrap, connectionHandler);
    }

    public B eventLoops(EventLoopGroup acceptorGroup, EventLoopGroup workerGroup) {
        ((ServerBootstrap)this.serverBootstrap).group(acceptorGroup, workerGroup);
        return (B)((ConnectionBasedServerBuilder)this.returnBuilder());
    }

    public <T> B childChannelOption(ChannelOption<T> option, T value) {
        ((ServerBootstrap)this.serverBootstrap).childOption(option, value);
        return (B)((ConnectionBasedServerBuilder)this.returnBuilder());
    }

    @Override
    protected Class<? extends ServerChannel> defaultServerChannelClass() {
        if (RxNetty.isUsingNativeTransport()) {
            return EpollServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    @Override
    protected void configureDefaultEventloopGroup() {
        ((ServerBootstrap)this.serverBootstrap).group(RxNetty.getRxEventLoopProvider().globalServerParentEventLoop(true), RxNetty.getRxEventLoopProvider().globalServerEventLoop(true));
    }

    @Override
    public B defaultChannelOptions() {
        this.channelOption(ChannelOption.SO_KEEPALIVE, true);
        this.childChannelOption(ChannelOption.SO_KEEPALIVE, true);
        this.childChannelOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
        return (B)((ConnectionBasedServerBuilder)super.defaultChannelOptions());
    }
}

