/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2;

public final class Server
implements Comparable<Server> {
    private final String host;
    private final int port;

    public Server(String host, int port) {
        this.port = port;
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Server)) {
            return false;
        }
        Server server = (Server)o;
        return this.port == server.port && !(this.host == null ? server.host != null : !this.host.equals(server.host));
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return "Server{host='" + this.host + '\'' + ", port=" + this.port + '}';
    }

    @Override
    public int compareTo(Server another) {
        int hostCompare = this.host.compareTo(another.host);
        return hostCompare == 0 ? this.port - another.port : hostCompare;
    }
}

