/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.channel;

import com.netflix.eureka2.channel.ServiceChannel;
import com.netflix.eureka2.metric.StateMachineMetrics;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;
import rx.subjects.ReplaySubject;
import rx.subjects.Subject;

public abstract class AbstractServiceChannel<STATE extends Enum<STATE>>
implements ServiceChannel {
    protected static final IllegalStateException CHANNEL_CLOSED_EXCEPTION = new IllegalStateException("Channel is already closed.");
    protected final String name = this.getClass().getSimpleName();
    protected final Subject<Void, Void> lifecycle;
    protected final AtomicReference<STATE> state;
    private final STATE initState;
    private final StateMachineMetrics<STATE> metrics;

    protected AbstractServiceChannel(STATE initState, StateMachineMetrics<STATE> metrics) {
        this.initState = initState;
        this.metrics = metrics;
        this.state = new AtomicReference<STATE>(initState);
        this.lifecycle = ReplaySubject.create();
    }

    @Override
    public Observable<Void> asLifecycleObservable() {
        return this.lifecycle;
    }

    @Override
    public final void close() {
        this._close();
        this.lifecycle.onCompleted();
    }

    @Override
    public final void close(Throwable error) {
        this._close();
        this.lifecycle.onError(error);
    }

    protected abstract void _close();

    protected <T> void connectInputToLifecycle(Observable<T> inputObservable, final Action1<T> onNext) {
        inputObservable.subscribe(new Subscriber<T>(){

            public void onCompleted() {
                AbstractServiceChannel.this.close();
            }

            public void onError(Throwable e) {
                AbstractServiceChannel.this.close(e);
            }

            public void onNext(T message) {
                onNext.call(message);
            }
        });
    }

    protected boolean moveToState(STATE from, STATE to) {
        if (this.state.compareAndSet(from, to)) {
            if (this.metrics != null) {
                if (from == this.initState) {
                    this.metrics.incrementStateCounter(to);
                } else {
                    this.metrics.stateTransition(from, to);
                    this.metrics.incrementStateCounter(to);
                    this.metrics.decrementStateCounter(from);
                }
            }
            return true;
        }
        return false;
    }

    protected STATE moveToState(STATE to) {
        Enum from = (Enum)this.state.getAndSet(to);
        if (this.metrics != null) {
            if (from == this.initState) {
                this.metrics.incrementStateCounter(to);
            } else {
                this.metrics.stateTransition(from, (Enum)to);
                this.metrics.incrementStateCounter(to);
                this.metrics.decrementStateCounter(from);
            }
        }
        return (STATE)from;
    }
}

