/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.client;

import com.netflix.eureka2.client.resolver.ServerResolver;
import com.netflix.eureka2.config.BasicEurekaRegistryConfig;
import com.netflix.eureka2.config.BasicEurekaTransportConfig;
import com.netflix.eureka2.config.EurekaRegistryConfig;
import com.netflix.eureka2.config.EurekaTransportConfig;
import com.netflix.eureka2.metric.EurekaRegistryMetricFactory;
import com.netflix.eureka2.metric.client.EurekaClientMetricFactory;

abstract class AbstractClientBuilder<CLIENT, T extends AbstractClientBuilder<CLIENT, T>> {
    protected ServerResolver serverResolver;
    protected EurekaTransportConfig transportConfig;
    protected EurekaRegistryConfig registryConfig;
    protected EurekaClientMetricFactory clientMetricFactory;
    protected EurekaRegistryMetricFactory registryMetricFactory;
    protected String clientId;

    AbstractClientBuilder() {
    }

    public T withServerResolver(ServerResolver serverResolver) {
        this.serverResolver = serverResolver;
        return this.self();
    }

    public T withTransportConfig(EurekaTransportConfig transportConfig) {
        this.transportConfig = transportConfig;
        return this.self();
    }

    public T withRegistryConfig(EurekaRegistryConfig registryConfig) {
        this.registryConfig = registryConfig;
        return this.self();
    }

    public T withClientMetricFactory(EurekaClientMetricFactory clientMetricFactory) {
        this.clientMetricFactory = clientMetricFactory;
        return this.self();
    }

    public T withRegistryMetricFactory(EurekaRegistryMetricFactory registryMetricFactory) {
        this.registryMetricFactory = registryMetricFactory;
        return this.self();
    }

    public T withClientId(String clientId) {
        this.clientId = clientId;
        return this.self();
    }

    public CLIENT build() {
        if (this.transportConfig == null) {
            this.transportConfig = new BasicEurekaTransportConfig.Builder().build();
        }
        if (this.registryConfig == null) {
            this.registryConfig = new BasicEurekaRegistryConfig.Builder().build();
        }
        if (this.clientMetricFactory == null) {
            this.clientMetricFactory = EurekaClientMetricFactory.clientMetrics();
        }
        if (this.registryMetricFactory == null) {
            this.registryMetricFactory = EurekaRegistryMetricFactory.registryMetrics();
        }
        return this.buildClient();
    }

    protected abstract CLIENT buildClient();

    protected T self() {
        return (T)this;
    }
}

