/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.client.channel;

import com.netflix.eureka2.channel.InterestChannel;
import com.netflix.eureka2.client.channel.ClientChannelFactory;
import com.netflix.eureka2.client.channel.InterestChannelImpl;
import com.netflix.eureka2.client.channel.InterestChannelInvoker;
import com.netflix.eureka2.client.interest.BatchingRegistry;
import com.netflix.eureka2.client.resolver.ServerResolver;
import com.netflix.eureka2.client.transport.TransportClients;
import com.netflix.eureka2.config.EurekaTransportConfig;
import com.netflix.eureka2.metric.client.EurekaClientMetricFactory;
import com.netflix.eureka2.registry.SourcedEurekaRegistry;
import com.netflix.eureka2.registry.instance.InstanceInfo;
import com.netflix.eureka2.transport.TransportClient;

public class InterestChannelFactory
extends ClientChannelFactory<InterestChannel> {
    private final SourcedEurekaRegistry<InstanceInfo> eurekaRegistry;
    private final TransportClient transport;
    private final BatchingRegistry<InstanceInfo> remoteBatchingRegistry;

    public InterestChannelFactory(String clientId, EurekaTransportConfig config, ServerResolver resolver, SourcedEurekaRegistry<InstanceInfo> eurekaRegistry, BatchingRegistry<InstanceInfo> remoteBatchingRegistry, EurekaClientMetricFactory metricFactory) {
        this(TransportClients.newTcpDiscoveryClient(clientId, config, resolver, metricFactory), eurekaRegistry, remoteBatchingRegistry, metricFactory);
    }

    public InterestChannelFactory(TransportClient transport, SourcedEurekaRegistry<InstanceInfo> eurekaRegistry, BatchingRegistry<InstanceInfo> remoteBatchingRegistry, EurekaClientMetricFactory metricFactory) {
        super(metricFactory);
        this.eurekaRegistry = eurekaRegistry;
        this.transport = transport;
        this.remoteBatchingRegistry = remoteBatchingRegistry;
    }

    @Override
    public InterestChannel newChannel() {
        InterestChannelImpl baseChannel = new InterestChannelImpl(this.eurekaRegistry, this.remoteBatchingRegistry, this.transport, this.metricFactory.getInterestChannelMetrics());
        return new InterestChannelInvoker(baseChannel, this.metricFactory);
    }

    @Override
    public void shutdown() {
        this.transport.shutdown();
    }
}

