/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.client.channel;

import com.netflix.eureka2.channel.InterestChannel;
import com.netflix.eureka2.interests.Interest;
import com.netflix.eureka2.metric.client.EurekaClientMetricFactory;
import com.netflix.eureka2.registry.instance.InstanceInfo;
import com.netflix.eureka2.utils.SerializedTaskInvoker;
import java.util.concurrent.Callable;
import rx.Observable;
import rx.Scheduler;
import rx.schedulers.Schedulers;

public class InterestChannelInvoker
extends SerializedTaskInvoker
implements InterestChannel {
    private final InterestChannel delegate;

    public InterestChannelInvoker(InterestChannel delegate, EurekaClientMetricFactory metricFactory) {
        this(delegate, metricFactory, Schedulers.computation());
    }

    public InterestChannelInvoker(InterestChannel delegate, EurekaClientMetricFactory metricFactory, Scheduler scheduler) {
        super(metricFactory.getSerializedTaskInvokerMetrics(InterestChannelInvoker.class), scheduler);
        this.delegate = delegate;
    }

    @Override
    public Observable<Void> change(final Interest<InstanceInfo> newInterest) {
        return this.submitForAck(new Callable<Observable<Void>>(){

            @Override
            public Observable<Void> call() throws Exception {
                return InterestChannelInvoker.this.delegate.change(newInterest);
            }

            public String toString() {
                return "change: " + newInterest;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.shutdown();
        }
        finally {
            this.delegate.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Throwable error) {
        try {
            this.shutdown();
        }
        finally {
            this.delegate.close(error);
        }
    }

    @Override
    public Observable<Void> asLifecycleObservable() {
        return this.delegate.asLifecycleObservable();
    }
}

