/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.client.channel;

import com.netflix.eureka2.channel.AbstractClientChannel;
import com.netflix.eureka2.channel.RegistrationChannel;
import com.netflix.eureka2.metric.RegistrationChannelMetrics;
import com.netflix.eureka2.protocol.registration.Register;
import com.netflix.eureka2.protocol.registration.Unregister;
import com.netflix.eureka2.registry.instance.InstanceInfo;
import com.netflix.eureka2.transport.MessageConnection;
import com.netflix.eureka2.transport.TransportClient;
import rx.Observable;
import rx.functions.Func1;

public class RegistrationChannelImpl
extends AbstractClientChannel<RegistrationChannel.STATE>
implements RegistrationChannel {
    private static final IllegalStateException INSTANCE_NOT_REGISTERED_EXCEPTION = new IllegalStateException("Instance is not registered yet.");

    public RegistrationChannelImpl(TransportClient transportClient, RegistrationChannelMetrics metrics) {
        super(RegistrationChannel.STATE.Idle, transportClient, metrics);
    }

    @Override
    public Observable<Void> register(final InstanceInfo instanceInfo) {
        if (!this.moveToState(RegistrationChannel.STATE.Idle, RegistrationChannel.STATE.Registered) && this.state.get() != RegistrationChannel.STATE.Registered) {
            RegistrationChannel.STATE currentState = (RegistrationChannel.STATE)((Object)this.state.get());
            if (currentState == RegistrationChannel.STATE.Closed) {
                return Observable.error((Throwable)CHANNEL_CLOSED_EXCEPTION);
            }
            return Observable.error((Throwable)new IllegalStateException("Error advancing to state Registered from state " + (Object)((Object)currentState)));
        }
        return this.connect().switchMap((Func1)new Func1<MessageConnection, Observable<? extends Void>>(){

            public Observable<? extends Void> call(MessageConnection connection) {
                return RegistrationChannelImpl.this.sendExpectAckOnConnection(connection, new Register(instanceInfo));
            }
        });
    }

    @Override
    public Observable<Void> unregister() {
        if (!this.moveToState(RegistrationChannel.STATE.Registered, RegistrationChannel.STATE.Closed)) {
            RegistrationChannel.STATE currentState = (RegistrationChannel.STATE)((Object)this.state.get());
            if (currentState == RegistrationChannel.STATE.Idle) {
                return Observable.error((Throwable)INSTANCE_NOT_REGISTERED_EXCEPTION);
            }
            if (currentState == RegistrationChannel.STATE.Closed) {
                return Observable.error((Throwable)CHANNEL_CLOSED_EXCEPTION);
            }
            return Observable.error((Throwable)new IllegalStateException("Error advancing to state Closed from state " + (Object)((Object)currentState)));
        }
        return this.connect().switchMap((Func1)new Func1<MessageConnection, Observable<? extends Void>>(){

            public Observable<? extends Void> call(MessageConnection connection) {
                return RegistrationChannelImpl.this.sendExpectAckOnConnection(connection, Unregister.INSTANCE);
            }
        });
    }

    @Override
    protected void _close() {
        if (this.state.get() != RegistrationChannel.STATE.Closed) {
            this.moveToState(RegistrationChannel.STATE.Closed);
            super._close();
        }
    }
}

