/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.client.functions;

import com.netflix.eureka2.Server;
import com.netflix.eureka2.interests.ChangeNotification;
import com.netflix.eureka2.interests.ChangeNotifications;
import com.netflix.eureka2.registry.instance.InstanceInfo;
import com.netflix.eureka2.registry.selector.ServiceSelector;
import java.net.InetSocketAddress;
import java.util.LinkedHashSet;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

public final class InterestFunctions {
    InterestFunctions() {
    }

    public static Func1<ChangeNotification<InstanceInfo>, ChangeNotification<Server>> instanceInfoToServer(final ServiceSelector serviceSelector) {
        return new Func1<ChangeNotification<InstanceInfo>, ChangeNotification<Server>>(){

            public ChangeNotification<Server> call(ChangeNotification<InstanceInfo> notification) {
                switch (notification.getKind()) {
                    case BufferSentinel: {
                        return ChangeNotification.bufferSentinel();
                    }
                    case Add: 
                    case Modify: 
                    case Delete: {
                        Server newServer = this.instanceInfoToServer(notification.getData());
                        if (newServer == null) break;
                        return new ChangeNotification<Server>(notification.getKind(), newServer);
                    }
                }
                return null;
            }

            private Server instanceInfoToServer(InstanceInfo instanceInfo) {
                InetSocketAddress socketAddress;
                if (instanceInfo.getStatus() == InstanceInfo.Status.UP && (socketAddress = serviceSelector.returnServiceAddress(instanceInfo)) != null) {
                    return new Server(socketAddress.getHostString(), socketAddress.getPort());
                }
                return null;
            }
        };
    }

    public static Observable.Transformer<ChangeNotification<InstanceInfo>, List<ChangeNotification<InstanceInfo>>> buffers() {
        return ChangeNotifications.buffers();
    }

    public static Observable.Transformer<List<ChangeNotification<InstanceInfo>>, LinkedHashSet<InstanceInfo>> snapshots() {
        return ChangeNotifications.snapshots();
    }
}

