/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.client.interest;

import com.netflix.eureka2.interests.Interest;
import com.netflix.eureka2.interests.MultipleInterests;
import com.netflix.eureka2.registry.instance.InstanceInfo;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import rx.Observable;
import rx.subjects.BehaviorSubject;
import rx.subjects.Subject;

public class InterestTracker {
    private final ConcurrentMap<Interest<InstanceInfo>, Integer> interests = new ConcurrentHashMap<Interest<InstanceInfo>, Integer>();
    private volatile MultipleInterests<InstanceInfo> multipleInterests = new MultipleInterests(new Interest[0]);
    private final Subject<Interest<InstanceInfo>, Interest<InstanceInfo>> interestSubject = BehaviorSubject.create();

    public synchronized void appendInterest(Interest<InstanceInfo> interest) {
        Integer refCount = this.interests.putIfAbsent(interest, 1);
        if (refCount != null) {
            this.interests.put(interest, refCount + 1);
        } else {
            this.multipleInterests = this.multipleInterests.copyAndAppend(interest);
            this.interestSubject.onNext(this.multipleInterests);
        }
    }

    public synchronized void removeInterest(Interest<InstanceInfo> interest) {
        Integer refCount = (Integer)this.interests.get(interest);
        if (refCount != null) {
            if (refCount <= 1) {
                this.interests.remove(interest);
                this.multipleInterests = this.multipleInterests.copyAndRemove(interest);
                this.interestSubject.onNext(this.multipleInterests);
            } else {
                this.interests.put(interest, refCount - 1);
            }
        }
    }

    public Observable<Interest<InstanceInfo>> interestChangeStream() {
        return this.interestSubject.asObservable().distinctUntilChanged();
    }

    public void close() {
        this.interests.clear();
        this.interestSubject.onCompleted();
    }
}

