/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.client.resolver;

import com.netflix.eureka2.Server;
import com.netflix.eureka2.client.EurekaInterestClient;
import com.netflix.eureka2.client.EurekaInterestClientBuilder;
import com.netflix.eureka2.client.channel.InterestChannelFactory;
import com.netflix.eureka2.client.functions.InterestFunctions;
import com.netflix.eureka2.client.interest.BatchingRegistry;
import com.netflix.eureka2.client.interest.BatchingRegistryImpl;
import com.netflix.eureka2.client.interest.EurekaInterestClientImpl;
import com.netflix.eureka2.client.resolver.EurekaRemoteResolverStep;
import com.netflix.eureka2.client.resolver.ServerResolver;
import com.netflix.eureka2.client.resolver.ServerResolvers;
import com.netflix.eureka2.interests.ChangeNotification;
import com.netflix.eureka2.interests.Interest;
import com.netflix.eureka2.interests.StreamStateNotification;
import com.netflix.eureka2.registry.MultiSourcedDataHolder;
import com.netflix.eureka2.registry.Source;
import com.netflix.eureka2.registry.SourcedEurekaRegistry;
import com.netflix.eureka2.registry.instance.InstanceInfo;
import com.netflix.eureka2.registry.instance.NetworkAddress;
import com.netflix.eureka2.registry.selector.ServiceSelector;
import com.netflix.eureka2.utils.rx.RxFunctions;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.subjects.PublishSubject;
import rx.subjects.Subject;

class DefaultEurekaResolverStep
implements EurekaRemoteResolverStep {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEurekaResolverStep.class);
    public static final String RESOLVER_CLIENT_ID = "resolverClient";
    private final ServiceSelector serviceSelector = ((ServiceSelector)ServiceSelector.selectBy().serviceLabel("discovery").protocolType(NetworkAddress.ProtocolType.IPv4).publicIp(true).or()).serviceLabel("discovery").protocolType(NetworkAddress.ProtocolType.IPv4);
    private final EurekaInterestClientBuilder interestClientBuilder;

    DefaultEurekaResolverStep(ServerResolver bootstrapResolver) {
        this((EurekaInterestClientBuilder)new ResolverEurekaInterestClientBuilder().withServerResolver(bootstrapResolver));
    }

    DefaultEurekaResolverStep(EurekaInterestClientBuilder interestClientBuilder) {
        this.interestClientBuilder = interestClientBuilder;
    }

    @Override
    public ServerResolver forInterest(final Interest<InstanceInfo> interest) {
        final AtomicReference interestClientRef = new AtomicReference();
        final AtomicLong duration = new AtomicLong();
        Observable instanceInfoSource = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<ChangeNotification<InstanceInfo>>(){

            public void call(Subscriber<? super ChangeNotification<InstanceInfo>> subscriber) {
                logger.info("Starting lite interestClient for eureka resolver");
                EurekaInterestClient interestClient = (EurekaInterestClient)DefaultEurekaResolverStep.this.interestClientBuilder.build();
                interestClientRef.set(interestClient);
                duration.set(System.currentTimeMillis());
                interestClient.forInterest(interest).subscribe(subscriber);
            }
        }).doOnUnsubscribe(new Action0(){

            public void call() {
                EurekaInterestClient interestClient = interestClientRef.getAndSet(null);
                if (interestClient != null) {
                    interestClient.shutdown();
                    logger.info("Shutting down lite interestClient for eureka resolver");
                }
                logger.info("Populating from remote eureka server took {} ms", (Object)(System.currentTimeMillis() - duration.get()));
            }
        });
        ServerResolver resolver = ServerResolvers.fromServerSource((Observable<ChangeNotification<Server>>)instanceInfoSource.map(InterestFunctions.instanceInfoToServer(this.serviceSelector)));
        return resolver;
    }

    static class PassThroughRegistry
    implements SourcedEurekaRegistry<InstanceInfo> {
        private final BatchingRegistry<InstanceInfo> remoteBatchingRegistry;
        private final Subject<ChangeNotification<InstanceInfo>, ChangeNotification<InstanceInfo>> relay = PublishSubject.create();

        PassThroughRegistry(BatchingRegistry<InstanceInfo> remoteBatchingRegistry) {
            this.remoteBatchingRegistry = remoteBatchingRegistry;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Observable<Boolean> register(InstanceInfo instanceInfo, Source source) {
            this.relay.onNext(new ChangeNotification<InstanceInfo>(ChangeNotification.Kind.Add, instanceInfo));
            return Observable.just((Object)true);
        }

        @Override
        public Observable<Boolean> unregister(InstanceInfo instanceInfo, Source source) {
            this.relay.onNext(new ChangeNotification<InstanceInfo>(ChangeNotification.Kind.Delete, instanceInfo));
            return Observable.just((Object)true);
        }

        @Override
        public Observable<InstanceInfo> forSnapshot(Interest<InstanceInfo> interest) {
            return Observable.error((Throwable)new UnsupportedOperationException("Not supported"));
        }

        @Override
        public Observable<InstanceInfo> forSnapshot(Interest<InstanceInfo> interest, Source.SourceMatcher sourceMatcher) {
            return Observable.error((Throwable)new UnsupportedOperationException("Not supported"));
        }

        @Override
        public Observable<ChangeNotification<InstanceInfo>> forInterest(final Interest<InstanceInfo> interest) {
            return this.relay.mergeWith(this.remoteBatchingRegistry.forInterest(interest).map((Func1)new Func1<StreamStateNotification.BufferState, ChangeNotification<InstanceInfo>>(){

                public ChangeNotification<InstanceInfo> call(StreamStateNotification.BufferState state) {
                    if (state == StreamStateNotification.BufferState.BufferEnd) {
                        return new StreamStateNotification<InstanceInfo>(state, interest);
                    }
                    return null;
                }
            }).filter(RxFunctions.filterNullValuesFunc()));
        }

        @Override
        public Observable<ChangeNotification<InstanceInfo>> forInterest(Interest<InstanceInfo> interest, Source.SourceMatcher sourceMatcher) {
            return Observable.error((Throwable)new UnsupportedOperationException("Not supported"));
        }

        @Override
        public Observable<Long> evictAllExcept(Source.SourceMatcher retainMatcher) {
            return Observable.just((Object)0L);
        }

        @Override
        public Observable<? extends MultiSourcedDataHolder<InstanceInfo>> getHolders() {
            return Observable.error((Throwable)new UnsupportedOperationException("Not supported"));
        }

        @Override
        public Observable<Void> shutdown() {
            this.remoteBatchingRegistry.shutdown();
            this.relay.onCompleted();
            return Observable.empty();
        }

        @Override
        public Observable<Void> shutdown(Throwable cause) {
            this.remoteBatchingRegistry.shutdown();
            this.relay.onError(cause);
            return Observable.empty();
        }
    }

    static class ResolverEurekaInterestClientBuilder
    extends EurekaInterestClientBuilder {
        ResolverEurekaInterestClientBuilder() {
        }

        @Override
        protected EurekaInterestClient buildClient() {
            if (this.serverResolver == null) {
                throw new IllegalArgumentException("Cannot build client for discovery without read server resolver");
            }
            BatchingRegistryImpl<InstanceInfo> remoteBatchingRegistry = new BatchingRegistryImpl<InstanceInfo>();
            PassThroughRegistry registry = new PassThroughRegistry(remoteBatchingRegistry);
            InterestChannelFactory channelFactory = new InterestChannelFactory(DefaultEurekaResolverStep.RESOLVER_CLIENT_ID, this.transportConfig, this.serverResolver, registry, remoteBatchingRegistry, this.clientMetricFactory);
            return new EurekaInterestClientImpl((SourcedEurekaRegistry<InstanceInfo>)registry, channelFactory);
        }
    }
}

