/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.client.resolver;

import com.netflix.eureka2.Server;
import com.netflix.eureka2.client.resolver.RoundRobinServerResolver;
import com.netflix.eureka2.interests.ChangeNotification;
import com.netflix.eureka2.utils.rx.ResourceObservable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.schedulers.Schedulers;

public class FileServerResolver
extends RoundRobinServerResolver {
    private final File textFile;
    private final Configuration configuration;

    FileServerResolver(File textFile) {
        this(textFile, new Configuration());
    }

    FileServerResolver(File textFile, Configuration configuration) {
        super(FileServerResolver.createServerSource(textFile, configuration));
        this.textFile = textFile;
        this.configuration = configuration;
    }

    public FileServerResolver configureReload(boolean alwaysReload, int reloadInterval, int idleTimeout, TimeUnit timeUnit) {
        Configuration updatedConfig = this.configuration.copy().withAlwaysReload(alwaysReload).withReloadInterval(reloadInterval).withIdleTimeout(idleTimeout).withTimeUnit(timeUnit);
        return new FileServerResolver(this.textFile, updatedConfig);
    }

    public FileServerResolver configureReloadScheduler(Scheduler scheduler) {
        Configuration updatedConfig = this.configuration.copy().withScheduler(scheduler);
        return new FileServerResolver(this.textFile, updatedConfig);
    }

    private static Observable<ChangeNotification<Server>> createServerSource(File textFile, Configuration configuration) {
        return ResourceObservable.fromResource(new FileResolveTask(textFile, configuration), configuration.reloadInterval, configuration.idleTimeout, configuration.timeUnit, configuration.scheduler);
    }

    private static class FileResolveTask
    implements ResourceObservable.ResourceLoader<ChangeNotification<Server>> {
        private final File textFile;
        private final Configuration configuration;
        private final ChangeNotification<Server> sentinel = ChangeNotification.bufferSentinel();
        private long lastModified = -1L;

        FileResolveTask(File textFile, Configuration configuration) {
            this.textFile = textFile;
            this.configuration = configuration;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ResourceObservable.ResourceUpdate<ChangeNotification<Server>> reload(Set<ChangeNotification<Server>> currentSnapshot) {
            if (!this.isUpdated()) {
                return new ResourceObservable.ResourceUpdate<ChangeNotification<Server>>(currentSnapshot, Collections.emptySet(), this.sentinel);
            }
            try (LineNumberReader reader = new LineNumberReader(new FileReader(this.textFile));){
                String line;
                HashSet<ChangeNotification<Server>> newAddresses = new HashSet<ChangeNotification<Server>>();
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    Server server = this.parseLine(reader.getLineNumber(), line);
                    newAddresses.add(new ChangeNotification<Server>(ChangeNotification.Kind.Add, server));
                }
                ResourceObservable.ResourceUpdate<ChangeNotification<Server>> resourceUpdate = new ResourceObservable.ResourceUpdate<ChangeNotification<Server>>(newAddresses, this.cancellationSet(currentSnapshot, newAddresses), this.sentinel);
                return resourceUpdate;
            }
            catch (IOException e) {
                if (this.lastModified != -1L) throw new ResourceObservable.ResourceLoaderException("Cannot reload server resolver file " + this.textFile, true, e);
                throw new ResourceObservable.ResourceLoaderException("Server resolver file missing on startup " + this.textFile, false, e);
            }
        }

        private Set<ChangeNotification<Server>> cancellationSet(Set<ChangeNotification<Server>> currentSnapshot, Set<ChangeNotification<Server>> newAddresses) {
            HashSet<ChangeNotification<Server>> cancelled = new HashSet<ChangeNotification<Server>>();
            for (ChangeNotification<Server> entry : currentSnapshot) {
                if (newAddresses.contains(entry)) continue;
                cancelled.add(new ChangeNotification<Server>(ChangeNotification.Kind.Delete, entry.getData()));
            }
            return cancelled;
        }

        private Server parseLine(int lineNumber, String line) {
            int idx = line.indexOf(59);
            if (idx == -1) {
                return new Server(line, 0);
            }
            String address = line.substring(0, idx);
            Integer port = null;
            int pos = idx + 1;
            while (pos < line.length()) {
                int eqIdx = line.indexOf(61, pos);
                if (eqIdx == -1) {
                    throw new IllegalArgumentException("Syntax error at line " + lineNumber);
                }
                String name = line.substring(pos, eqIdx);
                int ampIdx = line.indexOf(38, eqIdx + 1);
                if (ampIdx == -1) {
                    ampIdx = line.length();
                }
                String value = line.substring(eqIdx + 1, ampIdx);
                if ("port".equals(name)) {
                    try {
                        port = Integer.valueOf(value);
                    }
                    catch (NumberFormatException ignored) {
                        throw new IllegalArgumentException("Syntax error at line " + lineNumber + " - not valid port number");
                    }
                } else {
                    throw new IllegalArgumentException("Syntax error at line " + lineNumber + " - unrecognized property");
                }
                pos = ampIdx + 1;
            }
            if (port == null) {
                throw new IllegalArgumentException("Syntax error at line " + lineNumber + " - port number must be defined");
            }
            return new Server(address, port);
        }

        boolean isUpdated() {
            if (this.configuration.alwaysReload) {
                return true;
            }
            long newLastModified = this.textFile.lastModified();
            if (newLastModified <= this.lastModified) {
                this.lastModified = newLastModified;
                return true;
            }
            return false;
        }
    }

    protected static class Configuration {
        boolean alwaysReload = false;
        long reloadInterval = -1L;
        long idleTimeout = -1L;
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        Scheduler scheduler = Schedulers.io();

        protected Configuration() {
        }

        public Configuration copy() {
            return new Configuration().withAlwaysReload(this.alwaysReload).withReloadInterval(this.reloadInterval).withIdleTimeout(this.idleTimeout).withTimeUnit(this.timeUnit).withScheduler(this.scheduler);
        }

        public Configuration withAlwaysReload(boolean alwaysReload) {
            this.alwaysReload = alwaysReload;
            return this;
        }

        public Configuration withReloadInterval(long reloadInterval) {
            this.reloadInterval = reloadInterval;
            return this;
        }

        public Configuration withIdleTimeout(long idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        public Configuration withTimeUnit(TimeUnit reloadUnit) {
            this.timeUnit = reloadUnit;
            return this;
        }

        public Configuration withScheduler(Scheduler scheduler) {
            this.scheduler = scheduler;
            return this;
        }
    }
}

