/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.codec.avro;

import com.eureka2.shading.apache.avro.Schema;
import com.eureka2.shading.apache.avro.reflect.ReflectData;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class SchemaReflectData
extends ReflectData {
    private final Map<String, Schema> schemaMap = new HashMap<String, Schema>();

    public SchemaReflectData(Schema rootSchema) {
        this.addSchema(rootSchema);
    }

    private void addSchema(Schema schema) {
        if (this.schemaMap.containsKey(schema.getFullName())) {
            return;
        }
        switch (schema.getType()) {
            case RECORD: {
                this.schemaMap.put(schema.getFullName(), schema);
                for (Schema.Field field : schema.getFields()) {
                    this.addSchema(field.schema());
                }
                break;
            }
            case ENUM: {
                this.schemaMap.put(schema.getFullName(), schema);
                break;
            }
            case ARRAY: {
                this.addSchema(schema.getElementType());
                break;
            }
            case MAP: {
                String name = schema.getName() + '#' + schema.getValueType().getFullName();
                this.schemaMap.put(name, schema);
                break;
            }
            case UNION: {
                for (Schema unionItem : schema.getTypes()) {
                    this.addSchema(unionItem);
                }
                break;
            }
        }
    }

    @Override
    protected Schema createSchema(Type type, Map<String, Schema> names) {
        String name;
        if (type instanceof Class) {
            name = ((Class)type).getName();
        } else if (type instanceof ParameterizedType) {
            name = ((Class)((ParameterizedType)type).getRawType()).getName();
        } else {
            throw new RuntimeException("unrecognized type class" + type);
        }
        Schema typeSchema = this.schemaMap.get(name);
        if (typeSchema == null) {
            return super.createSchema(type, names);
        }
        return typeSchema;
    }
}

