/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.config;

import com.netflix.eureka2.codec.CodecType;
import com.netflix.eureka2.config.EurekaTransportConfig;
import com.netflix.eureka2.config.SystemConfigLoader;

public class BasicEurekaTransportConfig
implements EurekaTransportConfig {
    public static final long HEARTBEAT_INTERVAL_MS = 30000L;
    public static final long CONNECTION_AUTO_TIMEOUT_MS = 1800000L;
    public static final CodecType DEFAULT_CODEC = CodecType.Avro;
    private final long heartbeatIntervalMs;
    private final long connectionAutoTimeoutMs;
    private final CodecType codec;

    private BasicEurekaTransportConfig(long heartbeatIntervalMs, long connectionAutoTimeoutMs, CodecType codec) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
        this.connectionAutoTimeoutMs = connectionAutoTimeoutMs;
        this.codec = codec;
    }

    @Override
    public long getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    @Override
    public long getConnectionAutoTimeoutMs() {
        return this.connectionAutoTimeoutMs;
    }

    @Override
    public CodecType getCodec() {
        return this.codec;
    }

    public String toString() {
        return "BasicEurekaTransportConfig{heartbeatIntervalMs=" + this.heartbeatIntervalMs + ", connectionAutoTimeoutMs=" + this.connectionAutoTimeoutMs + ", codec=" + (Object)((Object)this.codec) + '}';
    }

    public static class Builder {
        private long heartbeatIntervalMs = SystemConfigLoader.getFromSystemPropertySafe("eureka.transport.heartbeatIntervalMs", 30000L);
        private long connectionAutoTimeoutMs = SystemConfigLoader.getFromSystemPropertySafe("eureka.transport.connectionAutoTimeoutMs", 1800000L);
        private CodecType codec = SystemConfigLoader.getFromSystemPropertySafe("eureka.transport.codec", DEFAULT_CODEC);

        public Builder withHeartbeatIntervalMs(long heartbeatIntervalMs) {
            this.heartbeatIntervalMs = heartbeatIntervalMs;
            return this;
        }

        public Builder withConnectionAutoTimeoutMs(long connectionAutoTimeoutMs) {
            this.connectionAutoTimeoutMs = connectionAutoTimeoutMs;
            return this;
        }

        public Builder withCodec(CodecType codec) {
            this.codec = codec;
            return this;
        }

        public BasicEurekaTransportConfig build() {
            return new BasicEurekaTransportConfig(this.heartbeatIntervalMs, this.connectionAutoTimeoutMs, this.codec);
        }
    }
}

