/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.eureka1.utils;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.LeaseInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.eureka2.registry.datacenter.AwsDataCenterInfo;
import com.netflix.eureka2.registry.datacenter.BasicDataCenterInfo;
import com.netflix.eureka2.registry.datacenter.DataCenterInfo;
import com.netflix.eureka2.registry.instance.InstanceInfo;
import com.netflix.eureka2.registry.instance.NetworkAddress;
import com.netflix.eureka2.registry.instance.ServicePort;
import com.netflix.eureka2.registry.selector.AddressSelector;
import com.netflix.eureka2.utils.ExtCollections;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Eureka1ModelConverters {
    private static final Logger logger = LoggerFactory.getLogger(Eureka1ModelConverters.class);
    private static final AddressSelector ADDRESS_SELECTOR = (AddressSelector)((AddressSelector)AddressSelector.selectBy().protocolType(NetworkAddress.ProtocolType.IPv4).publicIp(true).or()).any();
    private static final MyEureka1xDataCenterInfo MY_OWN_DATA_CENTER_INFO = new MyEureka1xDataCenterInfo();
    private static final Comparator<com.netflix.appinfo.InstanceInfo> V1_INSTANCE_IDENTITY_COMPARATOR = new Comparator<com.netflix.appinfo.InstanceInfo>(){

        @Override
        public int compare(com.netflix.appinfo.InstanceInfo o1, com.netflix.appinfo.InstanceInfo o2) {
            return o1.getId().compareTo(o2.getId());
        }
    };

    private Eureka1ModelConverters() {
    }

    public static Comparator<com.netflix.appinfo.InstanceInfo> v1InstanceIdentityComparator() {
        return V1_INSTANCE_IDENTITY_COMPARATOR;
    }

    public static InstanceInfo.InstanceStatus toEureka1xStatus(InstanceInfo.Status v2Status) {
        switch (v2Status) {
            case DOWN: {
                return InstanceInfo.InstanceStatus.DOWN;
            }
            case OUT_OF_SERVICE: {
                return InstanceInfo.InstanceStatus.OUT_OF_SERVICE;
            }
            case STARTING: {
                return InstanceInfo.InstanceStatus.STARTING;
            }
            case UNKNOWN: {
                return InstanceInfo.InstanceStatus.UNKNOWN;
            }
            case UP: {
                return InstanceInfo.InstanceStatus.UP;
            }
        }
        throw new IllegalStateException("Unexpected Eureka 2.x status " + (Object)((Object)v2Status));
    }

    public static com.netflix.appinfo.DataCenterInfo toEureka1xDataCenterInfo(DataCenterInfo v2DataCenterInfo) {
        if (v2DataCenterInfo instanceof AwsDataCenterInfo) {
            return Eureka1ModelConverters.toEureka1xDataCenterInfo((AwsDataCenterInfo)v2DataCenterInfo);
        }
        return MY_OWN_DATA_CENTER_INFO;
    }

    public static AmazonInfo toEureka1xDataCenterInfo(AwsDataCenterInfo v2DataCenterInfo) {
        AmazonInfo.Builder builder = AmazonInfo.Builder.newBuilder();
        builder.addMetadata(AmazonInfo.MetaDataKey.amiId, v2DataCenterInfo.getAmiId());
        builder.addMetadata(AmazonInfo.MetaDataKey.availabilityZone, v2DataCenterInfo.getZone());
        builder.addMetadata(AmazonInfo.MetaDataKey.instanceId, v2DataCenterInfo.getInstanceId());
        builder.addMetadata(AmazonInfo.MetaDataKey.instanceType, v2DataCenterInfo.getInstanceType());
        builder.addMetadata(AmazonInfo.MetaDataKey.localIpv4, v2DataCenterInfo.getPrivateAddress() == null ? "" : v2DataCenterInfo.getPrivateAddress().getIpAddress());
        builder.addMetadata(AmazonInfo.MetaDataKey.publicHostname, v2DataCenterInfo.getPublicAddress() == null ? "" : v2DataCenterInfo.getPublicAddress().getHostName());
        builder.addMetadata(AmazonInfo.MetaDataKey.publicIpv4, v2DataCenterInfo.getPublicAddress() == null ? "" : v2DataCenterInfo.getPublicAddress().getIpAddress());
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public static com.netflix.appinfo.InstanceInfo toEureka1xInstanceInfo(InstanceInfo v2InstanceInfo, InstanceInfo.ActionType actionType) {
        try {
            InstanceInfo.Builder builder = InstanceInfo.Builder.newBuilder();
            builder.setAppGroupName(v2InstanceInfo.getAppGroup());
            builder.setAppName(v2InstanceInfo.getApp());
            builder.setASGName(v2InstanceInfo.getAsg());
            builder.setVIPAddress(v2InstanceInfo.getVipAddress());
            builder.setSecureVIPAddress(v2InstanceInfo.getSecureVipAddress());
            builder.setStatus(Eureka1ModelConverters.toEureka1xStatus(v2InstanceInfo.getStatus()));
            NetworkAddress address = ADDRESS_SELECTOR.returnAddress(v2InstanceInfo.getDataCenterInfo().getAddresses());
            if (address != null) {
                builder.setHostName(address.getHostName() == null ? address.getIpAddress() : address.getHostName());
                builder.setIPAddr(address.getIpAddress() == null ? "" : address.getIpAddress());
            } else {
                logger.warn("Network address is null for {}", (Object)v2InstanceInfo);
            }
            if (v2InstanceInfo.getHomePageUrl() != null) {
                builder.setHomePageUrl(Eureka1ModelConverters.relativeUrlOf(v2InstanceInfo.getHomePageUrl()), v2InstanceInfo.getHomePageUrl());
            }
            if (v2InstanceInfo.getStatusPageUrl() != null) {
                builder.setStatusPageUrl(Eureka1ModelConverters.relativeUrlOf(v2InstanceInfo.getStatusPageUrl()), v2InstanceInfo.getStatusPageUrl());
            }
            if (v2InstanceInfo.getHealthCheckUrls() != null) {
                void var5_7;
                String explicitHealthCheckUrl = null;
                Object var5_6 = null;
                for (String url : v2InstanceInfo.getHealthCheckUrls()) {
                    if (url.startsWith("https")) {
                        if (var5_7 != null) continue;
                        String string = url;
                        continue;
                    }
                    if (explicitHealthCheckUrl != null) continue;
                    explicitHealthCheckUrl = url;
                }
                String relativeHealthCheckUrl = explicitHealthCheckUrl != null ? Eureka1ModelConverters.relativeUrlOf(explicitHealthCheckUrl) : Eureka1ModelConverters.relativeUrlOf((String)var5_7);
                builder.setHealthCheckUrls(relativeHealthCheckUrl, explicitHealthCheckUrl, (String)var5_7);
            }
            builder.setLeaseInfo(Eureka1ModelConverters.createDummyLeaseInfo());
            builder.setDataCenterInfo(Eureka1ModelConverters.toEureka1xDataCenterInfo(v2InstanceInfo.getDataCenterInfo()));
            for (ServicePort servicePort : v2InstanceInfo.getPorts()) {
                if (servicePort.isSecure()) {
                    builder.enablePort(InstanceInfo.PortType.SECURE, true);
                    builder.setSecurePort(servicePort.getPort().intValue());
                    continue;
                }
                builder.enablePort(InstanceInfo.PortType.UNSECURE, true);
                builder.setPort(servicePort.getPort().intValue());
            }
            if (v2InstanceInfo.getMetaData() != null) {
                for (Map.Entry entry : v2InstanceInfo.getMetaData().entrySet()) {
                    builder.add((String)entry.getKey(), (String)entry.getValue());
                }
            }
            com.netflix.appinfo.InstanceInfo v1InstanceInfo = builder.build();
            v1InstanceInfo.setActionType(actionType);
            return v1InstanceInfo;
        }
        catch (Exception e) {
            logger.error("failed to convert eureka2 instanceInfo to eureka1: {}", (Object)v2InstanceInfo);
            return null;
        }
    }

    public static com.netflix.appinfo.InstanceInfo toEureka1xInstanceInfo(InstanceInfo v2InstanceInfo) {
        return Eureka1ModelConverters.toEureka1xInstanceInfo(v2InstanceInfo, null);
    }

    public static List<com.netflix.appinfo.InstanceInfo> toEureka1xInstanceInfos(Collection<InstanceInfo> v2Instances) {
        ArrayList<com.netflix.appinfo.InstanceInfo> v1Instances = new ArrayList<com.netflix.appinfo.InstanceInfo>(v2Instances.size());
        for (InstanceInfo v2Instance : v2Instances) {
            v1Instances.add(Eureka1ModelConverters.toEureka1xInstanceInfo(v2Instance));
        }
        return v1Instances;
    }

    public static LeaseInfo createDummyLeaseInfo() {
        LeaseInfo.Builder leaseBuilder = LeaseInfo.Builder.newBuilder();
        leaseBuilder.setDurationInSecs(30);
        long now = System.currentTimeMillis();
        leaseBuilder.setRegistrationTimestamp(now);
        leaseBuilder.setRenewalIntervalInSecs(30);
        leaseBuilder.setRenewalTimestamp(now);
        return leaseBuilder.build();
    }

    public static Application toEureka1xApplication(String applicationName, Collection<InstanceInfo> applicationV2Instances) {
        Application application = new Application(applicationName);
        for (InstanceInfo v2Instance : applicationV2Instances) {
            application.addInstance(Eureka1ModelConverters.toEureka1xInstanceInfo(v2Instance));
        }
        return application;
    }

    public static Applications toEureka1xApplicationsFromV2Collection(Collection<InstanceInfo> v2Instances) {
        return Eureka1ModelConverters.toEureka1xApplications(Eureka1ModelConverters.toEureka1xInstanceInfos(v2Instances));
    }

    public static Applications toEureka1xApplications(Collection<com.netflix.appinfo.InstanceInfo> v1Instances) {
        HashMap<String, Application> applicationMap = new HashMap<String, Application>();
        for (com.netflix.appinfo.InstanceInfo v1Instance : v1Instances) {
            String appName = v1Instance.getAppName().toUpperCase(Locale.ROOT);
            Application application = (Application)applicationMap.get(appName);
            if (application == null) {
                application = new Application(appName);
                applicationMap.put(appName, application);
            }
            application.addInstance(v1Instance);
        }
        Applications applications = new Applications();
        for (Application app : applicationMap.values()) {
            applications.addApplication(app);
        }
        applications.setAppsHashCode(applications.getReconcileHashCode());
        return applications;
    }

    public static InstanceInfo.Status tuEureka2xStatus(InstanceInfo.InstanceStatus v1Status) {
        switch (v1Status) {
            case DOWN: {
                return InstanceInfo.Status.DOWN;
            }
            case OUT_OF_SERVICE: {
                return InstanceInfo.Status.OUT_OF_SERVICE;
            }
            case STARTING: {
                return InstanceInfo.Status.STARTING;
            }
            case UNKNOWN: {
                return InstanceInfo.Status.UNKNOWN;
            }
            case UP: {
                return InstanceInfo.Status.UP;
            }
        }
        throw new IllegalStateException("Unexpected Eureka 1.x status " + v1Status);
    }

    public static DataCenterInfo toEureka2xDataCenterInfo(com.netflix.appinfo.DataCenterInfo v1DataCenterInfo) {
        DataCenterInfo.DataCenterInfoBuilder builder;
        if (v1DataCenterInfo instanceof AmazonInfo) {
            AmazonInfo v1Info = (AmazonInfo)v1DataCenterInfo;
            builder = new AwsDataCenterInfo.Builder().withZone(v1Info.get(AmazonInfo.MetaDataKey.availabilityZone)).withAmiId(v1Info.get(AmazonInfo.MetaDataKey.amiId)).withInstanceId(v1Info.get(AmazonInfo.MetaDataKey.instanceId)).withInstanceType(v1Info.get(AmazonInfo.MetaDataKey.instanceType)).withPrivateIPv4(v1Info.get(AmazonInfo.MetaDataKey.localIpv4)).withPublicIPv4(v1Info.get(AmazonInfo.MetaDataKey.publicIpv4)).withPublicHostName(v1Info.get(AmazonInfo.MetaDataKey.publicHostname));
        } else {
            builder = new BasicDataCenterInfo.Builder().withName(v1DataCenterInfo.getName().name());
        }
        return ((DataCenterInfo.DataCenterInfoBuilder)builder).build();
    }

    public static InstanceInfo toEureka2xInstanceInfo(com.netflix.appinfo.InstanceInfo v1InstanceInfo) {
        InstanceInfo.Builder builder = new InstanceInfo.Builder().withId(v1InstanceInfo.getAppName() + '_' + v1InstanceInfo.getId()).withAppGroup(v1InstanceInfo.getAppGroupName()).withApp(v1InstanceInfo.getAppName()).withAsg(v1InstanceInfo.getASGName()).withVipAddress(v1InstanceInfo.getVIPAddress()).withSecureVipAddress(v1InstanceInfo.getSecureVipAddress()).withPorts(ExtCollections.asSet(new ServicePort(v1InstanceInfo.getPort(), false), new ServicePort(v1InstanceInfo.getSecurePort(), true))).withStatus(Eureka1ModelConverters.tuEureka2xStatus(v1InstanceInfo.getStatus())).withHomePageUrl(v1InstanceInfo.getHomePageUrl()).withStatusPageUrl(v1InstanceInfo.getStatusPageUrl()).withHealthCheckUrls(new HashSet<String>(v1InstanceInfo.getHealthCheckUrls())).withMetaData(v1InstanceInfo.getMetadata()).withDataCenterInfo(Eureka1ModelConverters.toEureka2xDataCenterInfo(v1InstanceInfo.getDataCenterInfo()));
        return builder.build();
    }

    private static String relativeUrlOf(String absoluteUrl) {
        if (absoluteUrl == null) {
            return null;
        }
        try {
            URI uri = new URI(absoluteUrl);
            return uri.getPath();
        }
        catch (URISyntaxException ignored) {
            return null;
        }
    }

    private static class MyEureka1xDataCenterInfo
    implements com.netflix.appinfo.DataCenterInfo {
        private MyEureka1xDataCenterInfo() {
        }

        public DataCenterInfo.Name getName() {
            return DataCenterInfo.Name.MyOwn;
        }
    }
}

