/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.health;

import com.netflix.eureka2.health.HealthStatusProvider;
import com.netflix.eureka2.health.HealthStatusUpdate;
import com.netflix.eureka2.health.SubsystemDescriptor;
import com.netflix.eureka2.registry.instance.InstanceInfo;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.subjects.BehaviorSubject;

public abstract class AbstractHealthStatusProvider<SUBSYSTEM>
implements HealthStatusProvider<SUBSYSTEM> {
    private final AtomicReference<InstanceInfo.Status> currentStatus;
    private final SubsystemDescriptor<SUBSYSTEM> descriptor;
    private final BehaviorSubject<HealthStatusUpdate<SUBSYSTEM>> healthSubject = BehaviorSubject.create();

    protected AbstractHealthStatusProvider(InstanceInfo.Status initialState, SubsystemDescriptor<SUBSYSTEM> descriptor) {
        this.currentStatus = new AtomicReference();
        this.descriptor = descriptor;
        this.moveHealthTo(initialState);
    }

    @Override
    public Observable<HealthStatusUpdate<SUBSYSTEM>> healthStatus() {
        return this.healthSubject;
    }

    public boolean moveHealthTo(InstanceInfo.Status newStatus) {
        if (this.currentStatus.getAndSet(newStatus) == newStatus) {
            return false;
        }
        this.healthSubject.onNext(new HealthStatusUpdate<SUBSYSTEM>(newStatus, this.descriptor));
        return true;
    }
}

