/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.interests;

import com.netflix.eureka2.interests.ChangeNotification;
import com.netflix.eureka2.interests.Index;
import com.netflix.eureka2.interests.IndexRegistry;
import com.netflix.eureka2.interests.Interest;
import com.netflix.eureka2.interests.MultipleInterests;
import com.netflix.eureka2.registry.SourcedEurekaRegistry;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rx.Observable;

public class IndexRegistryImpl<T>
implements IndexRegistry<T> {
    final ConcurrentHashMap<Interest<T>, Index<T>> interestVsIndex = new ConcurrentHashMap();

    @Override
    public Observable<ChangeNotification<T>> forInterest(Interest<T> interest, Observable<ChangeNotification<T>> dataSource, Index.InitStateHolder<T> initStateHolder) {
        Index<T> index = this.interestVsIndex.get(interest);
        if (null != index) {
            return index;
        }
        index = Index.forInterest(interest, dataSource, initStateHolder);
        Index<T> existing = this.interestVsIndex.putIfAbsent(interest, index);
        if (null != existing) {
            index.onCompleted();
            return existing;
        }
        return index;
    }

    @Override
    public Observable<ChangeNotification<T>> forCompositeInterest(MultipleInterests<T> interest, SourcedEurekaRegistry<T> registry) {
        ArrayList<Observable<ChangeNotification<T>>> indexes = new ArrayList<Observable<ChangeNotification<T>>>();
        for (Interest<T> atomicInterest : interest.flatten()) {
            indexes.add(registry.forInterest(atomicInterest));
        }
        return Observable.merge(indexes);
    }

    @Override
    public Observable<Void> shutdown() {
        for (Index<T> index : this.interestVsIndex.values()) {
            index.onCompleted();
        }
        this.interestVsIndex.clear();
        return Observable.empty();
    }

    @Override
    public Observable<Void> shutdown(Throwable cause) {
        for (Index<T> index : this.interestVsIndex.values()) {
            index.onError(cause);
        }
        this.interestVsIndex.clear();
        return Observable.empty();
    }

    public String toString() {
        return this.prettyString();
    }

    private String prettyString() {
        StringBuilder sb = new StringBuilder("IndexRegistryImpl\n");
        for (Map.Entry<Interest<T>, Index<T>> entry : this.interestVsIndex.entrySet()) {
            sb.append(entry).append("\n");
        }
        return sb.toString();
    }
}

