/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.interests;

import com.netflix.eureka2.interests.ChangeNotification;
import com.netflix.eureka2.interests.Index;
import com.netflix.eureka2.interests.Interest;
import com.netflix.eureka2.interests.SourcedChangeNotification;
import com.netflix.eureka2.interests.StreamStateNotification;
import com.netflix.eureka2.registry.Sourced;
import com.netflix.eureka2.registry.instance.InstanceInfo;
import com.netflix.eureka2.utils.ExtCollections;
import com.netflix.eureka2.utils.rx.PauseableSubject;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceInfoInitStateHolder
extends Index.InitStateHolder<InstanceInfo> {
    private static final Logger logger = LoggerFactory.getLogger(InstanceInfoInitStateHolder.class);
    private final ConcurrentHashMap<String, ChangeNotification<InstanceInfo>> notificationMap;
    private final ChangeNotification<InstanceInfo> bufferStartNotification;
    private final ChangeNotification<InstanceInfo> bufferEndNotification;

    public InstanceInfoInitStateHolder(Iterator<ChangeNotification<InstanceInfo>> initialRegistry, Interest<InstanceInfo> interest) {
        super(PauseableSubject.create());
        this.bufferStartNotification = new StreamStateNotification<InstanceInfo>(StreamStateNotification.BufferState.BufferStart, interest);
        this.bufferEndNotification = new StreamStateNotification<InstanceInfo>(StreamStateNotification.BufferState.BufferEnd, interest);
        this.notificationMap = new ConcurrentHashMap();
        while (initialRegistry.hasNext()) {
            ChangeNotification<InstanceInfo> next = initialRegistry.next();
            this.notificationMap.put(next.getData().getId(), next);
        }
    }

    @Override
    protected void addNotification(ChangeNotification<InstanceInfo> notification) {
        String id = notification.getData().getId();
        ChangeNotification<InstanceInfo> current = this.notificationMap.get(id);
        ChangeNotification<InstanceInfo> updated = InstanceInfoInitStateHolder.processNext(current, notification);
        if (updated != null) {
            this.notificationMap.put(id, updated);
        } else if (current != null) {
            this.notificationMap.remove(id);
        }
    }

    @Override
    protected void clearAllNotifications() {
        this.notificationMap.clear();
    }

    @Override
    protected Iterator<ChangeNotification<InstanceInfo>> _newIterator() {
        if (this.notificationMap.isEmpty()) {
            return ExtCollections.singletonIterator(this.bufferEndNotification);
        }
        return ExtCollections.concat(ExtCollections.singletonIterator(this.bufferStartNotification), this.notificationMap.values().iterator(), ExtCollections.singletonIterator(this.bufferEndNotification));
    }

    private static ChangeNotification<InstanceInfo> processNext(ChangeNotification<InstanceInfo> current, ChangeNotification<InstanceInfo> update) {
        switch (update.getKind()) {
            case Add: {
                return update;
            }
            case Modify: {
                if (current == null) {
                    logger.info("Invalid change notification sequence - 'Modify' ChangeNotification without proceeding 'Add' notification;for client view consistency converted to 'Add': {}", update);
                }
                if (update instanceof Sourced) {
                    return new SourcedChangeNotification<InstanceInfo>(ChangeNotification.Kind.Add, update.getData(), ((Sourced)((Object)update)).getSource());
                }
                return new ChangeNotification<InstanceInfo>(ChangeNotification.Kind.Add, update.getData());
            }
        }
        return null;
    }
}

