/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.interests.host;

import com.netflix.eureka2.interests.ChangeNotification;
import com.netflix.eureka2.interests.ChangeNotificationSource;
import com.netflix.eureka2.interests.Interest;
import com.netflix.eureka2.interests.host.DnsResolver;
import com.netflix.eureka2.utils.rx.ResourceObservable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingException;
import rx.Observable;
import rx.Scheduler;
import rx.schedulers.Schedulers;

public class DnsChangeNotificationSource
implements ChangeNotificationSource<String> {
    public static final long DNS_LOOKUP_INTERVAL = 30L;
    public static final long IDLE_TIMEOUT = 300L;
    private final String domainName;
    private final Observable<ChangeNotification<String>> resolverObservable;

    public DnsChangeNotificationSource(String domainName) {
        this(domainName, 30L, 300L, TimeUnit.SECONDS, Schedulers.io());
    }

    public DnsChangeNotificationSource(String domainName, long reloadInterval, TimeUnit timeUnit) {
        this(domainName, reloadInterval, -1L, timeUnit, Schedulers.io());
    }

    public DnsChangeNotificationSource(String domainName, long reloadInterval, long idleTimeout, TimeUnit reloadUnit, Scheduler scheduler) {
        this.domainName = domainName;
        this.resolverObservable = "localhost".equals(domainName) ? Observable.just(new ChangeNotification<String>(ChangeNotification.Kind.Add, domainName)) : ResourceObservable.fromResource(new DnsResolverTask(), reloadInterval, idleTimeout, reloadUnit, scheduler);
    }

    @Override
    public Observable<String> forSnapshot(Interest<String> interest) {
        throw new IllegalStateException("operation not supported");
    }

    @Override
    public Observable<ChangeNotification<String>> forInterest(Interest<String> interest) {
        return this.resolverObservable;
    }

    class DnsResolverTask
    implements ResourceObservable.ResourceLoader<ChangeNotification<String>> {
        private final ChangeNotification<String> sentinel = ChangeNotification.bufferSentinel();
        private boolean succeededOnce;

        DnsResolverTask() {
        }

        @Override
        public ResourceObservable.ResourceUpdate<ChangeNotification<String>> reload(Set<ChangeNotification<String>> currentSnapshot) {
            try {
                Set<ChangeNotification<String>> newAddresses = DnsResolver.resolveServerDN(DnsChangeNotificationSource.this.domainName);
                this.succeededOnce = true;
                return new ResourceObservable.ResourceUpdate<ChangeNotification<String>>(newAddresses, this.cancellationSet(currentSnapshot, newAddresses), this.sentinel);
            }
            catch (NamingException e) {
                if (this.succeededOnce) {
                    throw new ResourceObservable.ResourceLoaderException("DNS failure on subsequent access", true, e);
                }
                throw new ResourceObservable.ResourceLoaderException("Cannot resolve DNS entry on startup", false, e);
            }
        }

        private Set<ChangeNotification<String>> cancellationSet(Set<ChangeNotification<String>> currentSnapshot, Set<ChangeNotification<String>> newAddresses) {
            HashSet<ChangeNotification<String>> cancelled = new HashSet<ChangeNotification<String>>();
            for (ChangeNotification<String> entry : currentSnapshot) {
                if (newAddresses.contains(entry)) continue;
                cancelled.add(new ChangeNotification<String>(ChangeNotification.Kind.Delete, entry.getData()));
            }
            return cancelled;
        }
    }
}

