/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.interests.host;

import com.netflix.eureka2.interests.ChangeNotification;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class DnsResolver {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ChangeNotification<String>> resolveServerDN(String domainName) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        try (InitialDirContext dirContext = new InitialDirContext(env);){
            Set<ChangeNotification<String>> set = DnsResolver.resolveName(dirContext, domainName);
            return set;
        }
    }

    private static Set<ChangeNotification<String>> resolveName(DirContext dirContext, String targetDN) throws NamingException {
        Attributes attrs = dirContext.getAttributes(targetDN, new String[]{"A", "CNAME", "TXT"});
        HashSet<ChangeNotification<String>> addresses = new HashSet<ChangeNotification<String>>();
        addresses.addAll(DnsResolver.toSetOfServerEntries(attrs, "A"));
        if (!addresses.isEmpty()) {
            return addresses;
        }
        addresses.addAll(DnsResolver.toSetOfServerEntries(attrs, "CNAME"));
        if (!addresses.isEmpty()) {
            return addresses;
        }
        addresses.addAll(DnsResolver.toSetOfServerEntries(attrs, "TXT"));
        if (!addresses.isEmpty()) {
            return addresses;
        }
        return addresses;
    }

    private static Set<String> toSetOfString(Attributes attrs, String attrName) throws NamingException {
        Attribute attr = attrs.get(attrName);
        if (attr == null) {
            return Collections.emptySet();
        }
        HashSet<String> resultSet = new HashSet<String>();
        NamingEnumeration<?> it = attr.getAll();
        while (it.hasMore()) {
            Object value = it.next();
            resultSet.add(value.toString());
        }
        return resultSet;
    }

    private static Set<ChangeNotification<String>> toSetOfServerEntries(Attributes attrs, String attrName) throws NamingException {
        Attribute attr = attrs.get(attrName);
        if (attr == null) {
            return Collections.emptySet();
        }
        HashSet<ChangeNotification<String>> resultSet = new HashSet<ChangeNotification<String>>();
        NamingEnumeration<?> it = attr.getAll();
        while (it.hasMore()) {
            Object value = it.next();
            resultSet.add(new ChangeNotification<String>(ChangeNotification.Kind.Add, String.valueOf(value)));
        }
        return resultSet;
    }
}

