/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.protocol.discovery;

import com.netflix.eureka2.interests.Interest;
import com.netflix.eureka2.interests.Interests;
import com.netflix.eureka2.interests.MultipleInterests;
import com.netflix.eureka2.registry.instance.InstanceInfo;
import java.util.Arrays;
import java.util.Set;

public class InterestRegistration {
    private final Interest<InstanceInfo>[] interests;

    public InterestRegistration() {
        this.interests = null;
    }

    public InterestRegistration(Interest<InstanceInfo> interest) {
        if (interest instanceof MultipleInterests) {
            Set<Interest<Interest>> set = ((MultipleInterests)interest).flatten();
            this.interests = set.toArray(new Interest[set.size()]);
        } else {
            this.interests = new Interest[]{interest};
        }
    }

    public Interest<InstanceInfo>[] getInterests() {
        return this.interests;
    }

    public Interest<InstanceInfo> toComposite() {
        if (this.interests.length == 0) {
            return Interests.forNone();
        }
        if (this.interests.length > 1) {
            return new MultipleInterests<InstanceInfo>(this.interests);
        }
        return this.interests[0];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterestRegistration that = (InterestRegistration)o;
        return Arrays.equals(this.interests, that.interests);
    }

    public int hashCode() {
        return this.interests != null ? Arrays.hashCode(this.interests) : 0;
    }

    public String toString() {
        return "InterestRegistration{interests=" + Arrays.toString(this.interests) + '}';
    }
}

