/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.protocol.discovery;

import com.netflix.eureka2.protocol.discovery.InterestSetNotification;
import com.netflix.eureka2.registry.datacenter.DataCenterInfo;
import com.netflix.eureka2.registry.instance.Delta;
import com.netflix.eureka2.registry.instance.InstanceInfoField;
import com.netflix.eureka2.registry.instance.ServicePort;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;

public class UpdateInstanceInfo<T>
implements InterestSetNotification {
    private final DeltaDTO<?> deltaDTO;

    protected UpdateInstanceInfo() {
        this.deltaDTO = null;
    }

    public UpdateInstanceInfo(Delta<?> delta) {
        this.deltaDTO = UpdateInstanceInfo.toDeltaDTO(delta);
    }

    public Delta<?> getDelta() {
        return this.deltaDTO.toDelta();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateInstanceInfo that = (UpdateInstanceInfo)o;
        return !(this.deltaDTO != null ? !this.deltaDTO.equals(that.deltaDTO) : that.deltaDTO != null);
    }

    public int hashCode() {
        return this.deltaDTO != null ? this.deltaDTO.hashCode() : 0;
    }

    public String toString() {
        return "UpdateInstanceInfo{deltaDTO=" + this.deltaDTO + '}';
    }

    static DeltaDTO<?> toDeltaDTO(Delta<?> delta) {
        Type type = delta.getField().getValueType();
        if (type instanceof Class) {
            Class ctype = (Class)type;
            if (ctype.equals(String.class)) {
                return new StringDeltaDTO(delta);
            }
            if (Enum.class.isAssignableFrom(ctype)) {
                return new EnumDeltaDTO((Delta<Enum>)delta);
            }
            if (DataCenterInfo.class.isAssignableFrom(ctype)) {
                return new DataCenterInfoDTO((Delta<DataCenterInfo>)delta);
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            if (Set.class.isAssignableFrom((Class)ptype.getRawType())) {
                Type targ = ptype.getActualTypeArguments()[0];
                if (ServicePort.class.equals((Object)targ)) {
                    return new SetServicePortDeltaDTO((Delta<Set<ServicePort>>)delta);
                }
                if (String.class.equals((Object)targ)) {
                    return new SetStringDeltaDTO((Delta<Set<String>>)delta);
                }
            } else if (Map.class.isAssignableFrom((Class)ptype.getRawType())) {
                Type keyType = ptype.getActualTypeArguments()[0];
                Type valueType = ptype.getActualTypeArguments()[1];
                if (String.class.equals((Object)keyType) && String.class.equals((Object)valueType)) {
                    return new MapStringDeltaDTO((Delta<Map<String, String>>)delta);
                }
            }
        }
        throw new IllegalArgumentException("Unexpected delta type " + type);
    }

    public static class DataCenterInfoDTO
    extends DeltaDTO<DataCenterInfo> {
        DataCenterInfo value;

        public DataCenterInfoDTO() {
        }

        public DataCenterInfoDTO(Delta<DataCenterInfo> delta) {
            super(delta);
            this.value = delta.getValue();
        }

        @Override
        public DataCenterInfo getValue() {
            return this.value;
        }
    }

    public static class MapStringDeltaDTO
    extends DeltaDTO<Map<String, String>> {
        Map<String, String> value;

        public MapStringDeltaDTO() {
        }

        public MapStringDeltaDTO(Delta<Map<String, String>> delta) {
            super(delta);
            this.value = delta.getValue();
        }

        @Override
        public Map<String, String> getValue() {
            return this.value;
        }
    }

    public static class SetStringDeltaDTO
    extends DeltaDTO<Set<String>> {
        Set<String> value;

        public SetStringDeltaDTO() {
        }

        public SetStringDeltaDTO(Delta<Set<String>> delta) {
            super(delta);
            this.value = delta.getValue();
        }

        @Override
        public Set<String> getValue() {
            return this.value;
        }
    }

    public static class SetServicePortDeltaDTO
    extends DeltaDTO<Set<ServicePort>> {
        Set<ServicePort> value;

        public SetServicePortDeltaDTO() {
        }

        public SetServicePortDeltaDTO(Delta<Set<ServicePort>> delta) {
            super(delta);
            this.value = delta.getValue();
        }

        @Override
        public Set<ServicePort> getValue() {
            return this.value;
        }
    }

    public static class EnumDeltaDTO
    extends DeltaDTO<Enum> {
        Enum value;

        public EnumDeltaDTO() {
        }

        public EnumDeltaDTO(Delta<Enum> delta) {
            super(delta);
            this.value = delta.getValue();
        }

        @Override
        public Enum getValue() {
            return this.value;
        }
    }

    public static class StringDeltaDTO
    extends DeltaDTO<String> {
        private String value;

        public StringDeltaDTO() {
        }

        public StringDeltaDTO(Delta<String> delta) {
            super(delta);
            this.value = delta.getValue();
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    static abstract class DeltaDTO<T> {
        protected final String id;
        protected final String fieldName;

        protected DeltaDTO() {
            this.id = null;
            this.fieldName = null;
        }

        protected DeltaDTO(Delta<T> delta) {
            this.id = delta.getId();
            this.fieldName = delta.getField().getFieldName().name();
        }

        public abstract T getValue();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeltaDTO deltaDTO = (DeltaDTO)o;
            if (this.fieldName != null ? !this.fieldName.equals(deltaDTO.fieldName) : deltaDTO.fieldName != null) {
                return false;
            }
            if (this.id != null ? !this.id.equals(deltaDTO.id) : deltaDTO.id != null) {
                return false;
            }
            T thisValue = this.getValue();
            T thatValue = deltaDTO.getValue();
            return !(thisValue != null ? !thisValue.equals(thatValue) : thatValue != null);
        }

        public Delta<T> toDelta() {
            return new Delta.Builder().withId(this.id).withDelta(InstanceInfoField.forName(InstanceInfoField.Name.forName(this.fieldName)), this.getValue()).build();
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
            T value = this.getValue();
            result = 31 * result + (value != null ? value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "DeltaDTO{id='" + this.id + '\'' + ", fieldName='" + this.fieldName + '\'' + ", value=" + this.getValue() + '}';
        }
    }
}

