/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.registry;

import com.netflix.eureka2.config.EurekaRegistryConfig;
import com.netflix.eureka2.health.AbstractHealthStatusProvider;
import com.netflix.eureka2.health.SubsystemDescriptor;
import com.netflix.eureka2.interests.ChangeNotification;
import com.netflix.eureka2.interests.Interest;
import com.netflix.eureka2.metric.EurekaRegistryMetricFactory;
import com.netflix.eureka2.metric.EurekaRegistryMetrics;
import com.netflix.eureka2.registry.MultiSourcedDataHolder;
import com.netflix.eureka2.registry.Source;
import com.netflix.eureka2.registry.SourcedEurekaRegistry;
import com.netflix.eureka2.registry.eviction.EvictionItem;
import com.netflix.eureka2.registry.eviction.EvictionQueue;
import com.netflix.eureka2.registry.eviction.EvictionQueueImpl;
import com.netflix.eureka2.registry.eviction.EvictionStrategy;
import com.netflix.eureka2.registry.eviction.EvictionStrategyProvider;
import com.netflix.eureka2.registry.instance.InstanceInfo;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;

public class PreservableEurekaRegistry
extends AbstractHealthStatusProvider<PreservableEurekaRegistry>
implements SourcedEurekaRegistry<InstanceInfo> {
    private static final Logger logger = LoggerFactory.getLogger(PreservableEurekaRegistry.class);
    private static final SubsystemDescriptor<PreservableEurekaRegistry> DESCRIPTOR = new SubsystemDescriptor<PreservableEurekaRegistry>(PreservableEurekaRegistry.class, "Preservable Eureka registry", "Prevents items from being evicted if there are massive abrupt network disconnects.");
    private final SourcedEurekaRegistry<InstanceInfo> eurekaRegistry;
    private final EvictionQueue evictionQueue;
    private final EvictionStrategy evictionStrategy;
    private final EurekaRegistryMetrics metrics;
    private final Subscription evictionSubscription;
    private final EvictionSubscriber evictionSubscriber;
    volatile int expectedRegistrySize;
    final AtomicBoolean selfPreservation = new AtomicBoolean();
    private final Action1<Boolean> increaseExpectedSize = new Action1<Boolean>(){

        public void call(Boolean status) {
            if (status.booleanValue()) {
                PreservableEurekaRegistry.this.expectedRegistrySize = Math.max(PreservableEurekaRegistry.this.expectedRegistrySize, PreservableEurekaRegistry.this.eurekaRegistry.size());
                PreservableEurekaRegistry.this.resumeEviction();
            }
        }
    };
    private final Action1<Boolean> decreaseExpectedSize = new Action1<Boolean>(){

        public void call(Boolean status) {
            if (status.booleanValue()) {
                PreservableEurekaRegistry.this.expectedRegistrySize = Math.max(0, PreservableEurekaRegistry.this.expectedRegistrySize - 1);
                PreservableEurekaRegistry.this.resumeEviction();
            }
        }
    };

    public PreservableEurekaRegistry(SourcedEurekaRegistry eurekaRegistry, EurekaRegistryConfig registryConfig, EurekaRegistryMetricFactory metricFactory) {
        this(eurekaRegistry, new EvictionQueueImpl(registryConfig, metricFactory), new EvictionStrategyProvider(registryConfig).get(), metricFactory);
    }

    @Inject
    public PreservableEurekaRegistry(@Named(value="delegate") SourcedEurekaRegistry eurekaRegistry, EvictionQueue evictionQueue, EvictionStrategy evictionStrategy, EurekaRegistryMetricFactory metricFactory) {
        super(InstanceInfo.Status.UP, DESCRIPTOR);
        this.eurekaRegistry = eurekaRegistry;
        this.evictionQueue = evictionQueue;
        this.evictionStrategy = evictionStrategy;
        this.metrics = metricFactory.getEurekaServerRegistryMetrics();
        this.evictionSubscriber = new EvictionSubscriber();
        this.evictionSubscription = evictionQueue.pendingEvictions().subscribe((Subscriber)this.evictionSubscriber);
    }

    @Override
    public Observable<Boolean> register(InstanceInfo instanceInfo, Source source) {
        Observable<Boolean> result = this.eurekaRegistry.register(instanceInfo, source);
        result.subscribe(this.increaseExpectedSize);
        return result;
    }

    @Override
    public Observable<Boolean> unregister(InstanceInfo instanceInfo, Source source) {
        Observable<Boolean> result = this.eurekaRegistry.unregister(instanceInfo, source);
        result.subscribe(this.decreaseExpectedSize);
        return result;
    }

    @Override
    public int size() {
        return this.eurekaRegistry.size();
    }

    @Override
    public Observable<InstanceInfo> forSnapshot(Interest<InstanceInfo> interest) {
        return this.eurekaRegistry.forSnapshot(interest);
    }

    @Override
    public Observable<InstanceInfo> forSnapshot(Interest<InstanceInfo> interest, Source.SourceMatcher sourceMatcher) {
        return this.eurekaRegistry.forSnapshot(interest, sourceMatcher);
    }

    @Override
    public Observable<ChangeNotification<InstanceInfo>> forInterest(Interest<InstanceInfo> interest) {
        return this.eurekaRegistry.forInterest(interest);
    }

    @Override
    public Observable<ChangeNotification<InstanceInfo>> forInterest(Interest<InstanceInfo> interest, Source.SourceMatcher sourceMatcher) {
        return this.eurekaRegistry.forInterest(interest, sourceMatcher);
    }

    @Override
    public Observable<? extends MultiSourcedDataHolder<InstanceInfo>> getHolders() {
        return Observable.error((Throwable)new UnsupportedOperationException("getHolders is not supported for PreservableEurekaRegistry"));
    }

    public boolean isInSelfPreservation() {
        return this.selfPreservation.get();
    }

    @Override
    public Observable<Long> evictAllExcept(final Source.SourceMatcher retainMatcher) {
        return this.eurekaRegistry.getHolders().doOnNext((Action1)new Action1<MultiSourcedDataHolder<InstanceInfo>>(){

            public void call(MultiSourcedDataHolder<InstanceInfo> holder) {
                for (Source source : holder.getAllSources()) {
                    if (retainMatcher.match(source)) continue;
                    PreservableEurekaRegistry.this.evictionQueue.add(holder.get(source), source);
                }
            }
        }).countLong().doOnError((Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                logger.error("Error adding items to eviction queue", throwable);
            }
        }).doOnCompleted(new Action0(){

            public void call() {
                logger.info("Completed adding items to eviction queue");
            }
        });
    }

    @Override
    @PreDestroy
    public Observable<Void> shutdown() {
        this.moveHealthTo(InstanceInfo.Status.DOWN);
        logger.info("Shutting down the preservable registry");
        this.evictionSubscription.unsubscribe();
        this.evictionQueue.shutdown();
        return this.eurekaRegistry.shutdown();
    }

    @Override
    public Observable<Void> shutdown(Throwable cause) {
        this.moveHealthTo(InstanceInfo.Status.DOWN);
        this.evictionSubscription.unsubscribe();
        this.evictionQueue.shutdown();
        return this.eurekaRegistry.shutdown(cause);
    }

    private boolean allowedToEvict() {
        boolean allowed = this.evictionStrategy.allowedToEvict(this.expectedRegistrySize, this.eurekaRegistry.size()) >= 0;
        return allowed;
    }

    private void resumeEviction() {
        if (this.selfPreservation.compareAndSet(true, false)) {
            this.metrics.setSelfPreservation(false);
            logger.info("Coming out of self preservation mode");
            this.evictionSubscriber.resume();
        }
    }

    private class EvictionSubscriber
    extends Subscriber<EvictionItem> {
        private EvictionSubscriber() {
        }

        public void onStart() {
            this.request(1L);
        }

        public void onCompleted() {
        }

        public void onError(Throwable e) {
        }

        public void onNext(final EvictionItem evictionItem) {
            PreservableEurekaRegistry.this.eurekaRegistry.unregister(evictionItem.getInstanceInfo(), evictionItem.getSource()).doOnCompleted(new Action0(){

                public void call() {
                    logger.info("Successfully evicted registry entry {}/{}", (Object)evictionItem.getSource(), (Object)evictionItem.getInstanceInfo().getId());
                }
            }).retry(2L).subscribe();
            if (PreservableEurekaRegistry.this.allowedToEvict()) {
                this.resume();
            } else {
                PreservableEurekaRegistry.this.selfPreservation.set(true);
                PreservableEurekaRegistry.this.metrics.setSelfPreservation(true);
                logger.info("Entering self preservation mode");
            }
        }

        public void resume() {
            this.request(1L);
        }
    }
}

