/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.registry;

import java.util.UUID;

public class Source {
    private final Origin origin;
    private final String name;
    private final String id;

    public Source(Origin origin) {
        this(origin, null);
    }

    public Source(Origin origin, String name) {
        this.origin = origin;
        this.name = name;
        this.id = UUID.randomUUID().toString();
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Source)) {
            return false;
        }
        Source source = (Source)o;
        if (this.id != null ? !this.id.equals(source.id) : source.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(source.name) : source.name != null) {
            return false;
        }
        return this.origin == source.origin;
    }

    public int hashCode() {
        int result = this.origin != null ? this.origin.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Source{origin=" + (Object)((Object)this.origin) + ", name='" + this.name + '\'' + ", id='" + this.id + '\'' + '}';
    }

    public static SourceMatcher matcherFor(final Source source) {
        return new SourceMatcher(){

            @Override
            public boolean match(Source another) {
                return source == null ? another == null : source.equals(another);
            }
        };
    }

    public static SourceMatcher matcherFor(final Origin origin) {
        return new SourceMatcher(){

            @Override
            public boolean match(Source another) {
                if (another == null) {
                    return false;
                }
                return origin.equals((Object)another.origin);
            }
        };
    }

    public static SourceMatcher matcherFor(final Origin origin, final String name) {
        return new SourceMatcher(){

            @Override
            public boolean match(Source another) {
                if (another == null) {
                    return false;
                }
                boolean originMatches = origin.equals((Object)another.origin);
                boolean nameMatches = name == null ? another.name == null : name.equals(another.name);
                return originMatches && nameMatches;
            }
        };
    }

    public static abstract class SourceMatcher {
        public abstract boolean match(Source var1);
    }

    public static enum Origin {
        LOCAL,
        REPLICATED,
        BOOTSTRAP,
        INTERESTED;

    }
}

