/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.registry.instance;

import com.netflix.eureka2.registry.datacenter.DataCenterInfo;
import com.netflix.eureka2.registry.instance.Delta;
import com.netflix.eureka2.registry.instance.InstanceInfoField;
import com.netflix.eureka2.registry.instance.NetworkAddress;
import com.netflix.eureka2.registry.instance.ServicePort;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class InstanceInfo {
    protected final String id;
    protected String appGroup;
    protected String app;
    protected String asg;
    protected String vipAddress;
    protected String secureVipAddress;
    protected HashSet<ServicePort> ports;
    protected Status status;
    protected String homePageUrl;
    protected String statusPageUrl;
    protected HashSet<String> healthCheckUrls;
    protected Map<String, String> metaData;
    protected DataCenterInfo dataCenterInfo;

    private InstanceInfo() {
        this(null);
    }

    protected InstanceInfo(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getAppGroup() {
        return this.appGroup;
    }

    public String getApp() {
        return this.app;
    }

    public String getAsg() {
        return this.asg;
    }

    public String getVipAddress() {
        return this.vipAddress;
    }

    public String getSecureVipAddress() {
        return this.secureVipAddress;
    }

    public HashSet<ServicePort> getPorts() {
        return this.ports;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getHomePageUrl() {
        return this.homePageUrl;
    }

    public String getStatusPageUrl() {
        return this.statusPageUrl;
    }

    public HashSet<String> getHealthCheckUrls() {
        return this.healthCheckUrls;
    }

    public DataCenterInfo getDataCenterInfo() {
        return this.dataCenterInfo;
    }

    public Map<String, String> getMetaData() {
        return this.metaData == null ? null : Collections.unmodifiableMap(this.metaData);
    }

    public Iterator<ServiceEndpoint> serviceEndpoints() {
        return ServiceEndpoint.iteratorFrom(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceInfo that = (InstanceInfo)o;
        if (this.app != null ? !this.app.equals(that.app) : that.app != null) {
            return false;
        }
        if (this.appGroup != null ? !this.appGroup.equals(that.appGroup) : that.appGroup != null) {
            return false;
        }
        if (this.asg != null ? !this.asg.equals(that.asg) : that.asg != null) {
            return false;
        }
        if (this.dataCenterInfo != null ? !this.dataCenterInfo.equals(that.dataCenterInfo) : that.dataCenterInfo != null) {
            return false;
        }
        if (this.healthCheckUrls != null ? !this.healthCheckUrls.equals(that.healthCheckUrls) : that.healthCheckUrls != null) {
            return false;
        }
        if (this.homePageUrl != null ? !this.homePageUrl.equals(that.homePageUrl) : that.homePageUrl != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.metaData != null ? !this.metaData.equals(that.metaData) : that.metaData != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.secureVipAddress != null ? !this.secureVipAddress.equals(that.secureVipAddress) : that.secureVipAddress != null) {
            return false;
        }
        if (this.status != that.status) {
            return false;
        }
        if (this.statusPageUrl != null ? !this.statusPageUrl.equals(that.statusPageUrl) : that.statusPageUrl != null) {
            return false;
        }
        return !(this.vipAddress != null ? !this.vipAddress.equals(that.vipAddress) : that.vipAddress != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.appGroup != null ? this.appGroup.hashCode() : 0);
        result = 31 * result + (this.app != null ? this.app.hashCode() : 0);
        result = 31 * result + (this.asg != null ? this.asg.hashCode() : 0);
        result = 31 * result + (this.vipAddress != null ? this.vipAddress.hashCode() : 0);
        result = 31 * result + (this.secureVipAddress != null ? this.secureVipAddress.hashCode() : 0);
        result = 31 * result + (this.ports != null ? this.ports.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.homePageUrl != null ? this.homePageUrl.hashCode() : 0);
        result = 31 * result + (this.statusPageUrl != null ? this.statusPageUrl.hashCode() : 0);
        result = 31 * result + (this.healthCheckUrls != null ? this.healthCheckUrls.hashCode() : 0);
        result = 31 * result + (this.metaData != null ? this.metaData.hashCode() : 0);
        result = 31 * result + (this.dataCenterInfo != null ? this.dataCenterInfo.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "InstanceInfo{id='" + this.id + '\'' + ", appGroup='" + this.appGroup + '\'' + ", app='" + this.app + '\'' + ", asg='" + this.asg + '\'' + ", vipAddress='" + this.vipAddress + '\'' + ", secureVipAddress='" + this.secureVipAddress + '\'' + ", ports=" + this.ports + ", status=" + (Object)((Object)this.status) + ", homePageUrl='" + this.homePageUrl + '\'' + ", statusPageUrl='" + this.statusPageUrl + '\'' + ", healthCheckUrls=" + this.healthCheckUrls + ", metaData=" + this.metaData + ", dataCenterInfo=" + this.dataCenterInfo + '}';
    }

    public InstanceInfo applyDelta(Delta delta) {
        if (!this.id.equals(delta.getId())) {
            throw new UnsupportedOperationException("Cannot apply delta to instanceInfo with non-matching id: " + delta.getId() + ", " + this.id);
        }
        Builder newInstanceInfoBuilder = new Builder().withInstanceInfo(this);
        return delta.applyTo(newInstanceInfoBuilder).build();
    }

    public Set<Delta<?>> diffNewer(InstanceInfo another) {
        return InstanceInfo.diff(this, another);
    }

    public Set<Delta<?>> diffOlder(InstanceInfo another) {
        return InstanceInfo.diff(another, this);
    }

    private static Set<Delta<?>> diff(InstanceInfo oldInstanceInfo, InstanceInfo newInstanceInfo) {
        if (oldInstanceInfo == null || newInstanceInfo == null) {
            return null;
        }
        if (!oldInstanceInfo.getId().equals(newInstanceInfo.getId())) {
            return null;
        }
        HashSet deltas = new HashSet();
        for (InstanceInfoField.Name fieldName : InstanceInfoField.Name.values()) {
            Object newValue;
            InstanceInfoField field = InstanceInfoField.forName(fieldName);
            Object oldValue = field.getValue(oldInstanceInfo);
            if (InstanceInfo.equalsNullable(oldValue, newValue = field.getValue(newInstanceInfo))) continue;
            Delta<?> delta = new Delta.Builder().withId(newInstanceInfo.getId()).withDelta(field, newValue).build();
            deltas.add(delta);
        }
        return deltas;
    }

    private static boolean equalsNullable(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static class ServiceEndpoint {
        private final NetworkAddress address;
        private final ServicePort servicePort;

        private ServiceEndpoint(NetworkAddress address, ServicePort servicePort) {
            this.address = address;
            this.servicePort = servicePort;
        }

        public NetworkAddress getAddress() {
            return this.address;
        }

        public ServicePort getServicePort() {
            return this.servicePort;
        }

        public static Iterator<ServiceEndpoint> iteratorFrom(InstanceInfo instanceInfo) {
            final List<NetworkAddress> addresses = instanceInfo.getDataCenterInfo().getAddresses();
            final HashSet<ServicePort> ports = instanceInfo.getPorts();
            if (ports == null || ports.isEmpty() || addresses == null || addresses.isEmpty()) {
                return Collections.emptyIterator();
            }
            return new Iterator<ServiceEndpoint>(){
                private final Iterator<ServicePort> servicePortIt;
                private ServicePort currentPort;
                private Iterator<NetworkAddress> networkAddressIt;
                {
                    this.servicePortIt = ports.iterator();
                    this.currentPort = this.servicePortIt.next();
                    this.networkAddressIt = addresses.iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.networkAddressIt.hasNext()) {
                        return true;
                    }
                    if (this.servicePortIt.hasNext()) {
                        this.currentPort = this.servicePortIt.next();
                        this.networkAddressIt = addresses.iterator();
                        return true;
                    }
                    return false;
                }

                @Override
                public ServiceEndpoint next() {
                    if (this.hasNext()) {
                        return new ServiceEndpoint(this.networkAddressIt.next(), this.currentPort);
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new IllegalStateException("Operation not supported");
                }
            };
        }
    }

    public static final class Builder {
        private String id;
        private String appGroup;
        private String app;
        private String asg;
        private String vipAddress;
        private String secureVipAddress;
        private HashSet<ServicePort> ports;
        private Status status;
        private String homePageUrl;
        private String statusPageUrl;
        private HashSet<String> healthCheckUrls;
        private DataCenterInfo dataCenterInfo;
        private Map<String, String> metaData;

        public Builder withInstanceInfo(InstanceInfo another) {
            this.id = another.id;
            this.appGroup = another.appGroup;
            this.app = another.app;
            this.asg = another.asg;
            this.vipAddress = another.vipAddress;
            this.secureVipAddress = another.secureVipAddress;
            this.ports = another.ports;
            this.status = another.status;
            this.homePageUrl = another.homePageUrl;
            this.statusPageUrl = another.statusPageUrl;
            this.healthCheckUrls = another.healthCheckUrls;
            this.metaData = another.metaData;
            this.dataCenterInfo = another.dataCenterInfo;
            return this;
        }

        public Builder withBuilder(Builder another) {
            this.id = another.id == null ? this.id : another.id;
            this.appGroup = another.appGroup == null ? this.appGroup : another.appGroup;
            this.app = another.app == null ? this.app : another.app;
            this.asg = another.asg == null ? this.asg : another.asg;
            this.vipAddress = another.vipAddress == null ? this.vipAddress : another.vipAddress;
            this.secureVipAddress = another.secureVipAddress == null ? this.secureVipAddress : another.secureVipAddress;
            this.ports = another.ports == null ? this.ports : new HashSet<ServicePort>(another.ports);
            this.status = another.status == null ? this.status : another.status;
            this.homePageUrl = another.homePageUrl == null ? this.homePageUrl : another.homePageUrl;
            this.statusPageUrl = another.statusPageUrl == null ? this.statusPageUrl : another.statusPageUrl;
            this.healthCheckUrls = another.healthCheckUrls == null ? this.healthCheckUrls : new HashSet<String>(another.healthCheckUrls);
            this.metaData = another.metaData == null ? this.metaData : new HashMap<String, String>(another.metaData);
            this.dataCenterInfo = another.dataCenterInfo == null ? this.dataCenterInfo : another.dataCenterInfo;
            return this;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withAppGroup(String appGroup) {
            this.appGroup = appGroup;
            return this;
        }

        public Builder withApp(String app) {
            this.app = app;
            return this;
        }

        public Builder withAsg(String asg) {
            this.asg = asg;
            return this;
        }

        public Builder withVipAddress(String vipAddress) {
            this.vipAddress = vipAddress;
            return this;
        }

        public Builder withSecureVipAddress(String secureVipAddress) {
            this.secureVipAddress = secureVipAddress;
            return this;
        }

        public Builder withPorts(HashSet<ServicePort> ports) {
            if (ports == null || ports.isEmpty()) {
                this.ports = null;
            } else {
                this.ports = new HashSet<ServicePort>(ports);
                this.ports.remove(null);
            }
            return this;
        }

        public Builder withPorts(ServicePort ... ports) {
            if (ports == null || ports.length == 0) {
                this.ports = null;
            }
            this.ports = new HashSet();
            Collections.addAll(this.ports, ports);
            return this;
        }

        public Builder withStatus(Status status) {
            this.status = status;
            return this;
        }

        public Builder withHomePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
            return this;
        }

        public Builder withStatusPageUrl(String statusPageUrl) {
            this.statusPageUrl = statusPageUrl;
            return this;
        }

        public Builder withHealthCheckUrls(HashSet<String> healthCheckUrls) {
            if (healthCheckUrls == null || healthCheckUrls.isEmpty()) {
                this.healthCheckUrls = null;
            } else {
                this.healthCheckUrls = new HashSet<String>(healthCheckUrls);
                this.healthCheckUrls.remove(null);
            }
            return this;
        }

        public Builder withMetaData(String key, String value) {
            if (this.metaData == null) {
                this.metaData = new HashMap<String, String>();
            }
            this.metaData.put(key, value);
            return this;
        }

        public Builder withMetaData(Map<String, String> metaData) {
            this.metaData = metaData;
            return this;
        }

        public Builder withDataCenterInfo(DataCenterInfo location) {
            this.dataCenterInfo = location;
            return this;
        }

        public InstanceInfo build() {
            if (this.id == null) {
                throw new IllegalArgumentException("InstanceInfo id cannot be null");
            }
            InstanceInfo result = new InstanceInfo(this.id);
            result.appGroup = this.appGroup;
            result.app = this.app;
            result.asg = this.asg;
            result.vipAddress = this.vipAddress;
            result.secureVipAddress = this.secureVipAddress;
            result.ports = this.ports;
            result.status = this.status;
            result.homePageUrl = this.homePageUrl;
            result.statusPageUrl = this.statusPageUrl;
            result.healthCheckUrls = this.healthCheckUrls;
            result.metaData = this.metaData;
            result.dataCenterInfo = this.dataCenterInfo;
            return result;
        }
    }

    public static enum Status {
        UP,
        DOWN,
        STARTING,
        OUT_OF_SERVICE,
        UNKNOWN;


        public static Status toEnum(String s) {
            for (Status e : Status.values()) {
                if (!e.name().equalsIgnoreCase(s)) continue;
                return e;
            }
            return UNKNOWN;
        }
    }
}

