/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.registry.instance;

import com.netflix.eureka2.registry.datacenter.DataCenterInfo;
import com.netflix.eureka2.registry.instance.InstanceInfo;
import com.netflix.eureka2.registry.instance.ServicePort;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class InstanceInfoField<T> {
    public static final InstanceInfoField<String> APPLICATION_GROUP = new InstanceInfoField<String>(Name.AppGroup, new Accessor<String>(){

        @Override
        public InstanceInfo.Builder update(InstanceInfo.Builder builder, String value) {
            return builder.withAppGroup(value);
        }

        @Override
        public String getValue(InstanceInfo instanceInfo) {
            return instanceInfo.getAppGroup();
        }
    });
    public static final InstanceInfoField<String> APPLICATION = new InstanceInfoField<String>(Name.App, new Accessor<String>(){

        @Override
        public InstanceInfo.Builder update(InstanceInfo.Builder builder, String value) {
            return builder.withApp(value);
        }

        @Override
        public String getValue(InstanceInfo instanceInfo) {
            return instanceInfo.getApp();
        }
    });
    public static final InstanceInfoField<String> ASG = new InstanceInfoField<String>(Name.Asg, new Accessor<String>(){

        @Override
        public InstanceInfo.Builder update(InstanceInfo.Builder builder, String value) {
            return builder.withAsg(value);
        }

        @Override
        public String getValue(InstanceInfo instanceInfo) {
            return instanceInfo.getAsg();
        }
    });
    public static final InstanceInfoField<String> VIP_ADDRESS = new InstanceInfoField<String>(Name.VipAddress, new Accessor<String>(){

        @Override
        public InstanceInfo.Builder update(InstanceInfo.Builder builder, String value) {
            return builder.withVipAddress(value);
        }

        @Override
        public String getValue(InstanceInfo instanceInfo) {
            return instanceInfo.getVipAddress();
        }
    });
    public static final InstanceInfoField<String> SECURE_VIP_ADDRESS = new InstanceInfoField<String>(Name.SecureVipAddress, new Accessor<String>(){

        @Override
        public InstanceInfo.Builder update(InstanceInfo.Builder builder, String value) {
            return builder.withSecureVipAddress(value);
        }

        @Override
        public String getValue(InstanceInfo instanceInfo) {
            return instanceInfo.getSecureVipAddress();
        }
    });
    public static final InstanceInfoField<HashSet<ServicePort>> PORTS = new InstanceInfoField<HashSet<ServicePort>>(Name.Ports, new Accessor<HashSet<ServicePort>>(){

        @Override
        public InstanceInfo.Builder update(InstanceInfo.Builder builder, HashSet<ServicePort> value) {
            return builder.withPorts(value);
        }

        @Override
        public HashSet<ServicePort> getValue(InstanceInfo instanceInfo) {
            return instanceInfo.getPorts();
        }
    });
    public static final InstanceInfoField<InstanceInfo.Status> STATUS = new InstanceInfoField<InstanceInfo.Status>(Name.Status, new Accessor<InstanceInfo.Status>(){

        @Override
        public InstanceInfo.Builder update(InstanceInfo.Builder builder, InstanceInfo.Status value) {
            return builder.withStatus(value);
        }

        @Override
        public InstanceInfo.Status getValue(InstanceInfo instanceInfo) {
            return instanceInfo.getStatus();
        }
    });
    public static final InstanceInfoField<String> HOMEPAGE_URL = new InstanceInfoField<String>(Name.HomePageUrl, new Accessor<String>(){

        @Override
        public InstanceInfo.Builder update(InstanceInfo.Builder builder, String value) {
            return builder.withHomePageUrl(value);
        }

        @Override
        public String getValue(InstanceInfo instanceInfo) {
            return instanceInfo.getHomePageUrl();
        }
    });
    public static final InstanceInfoField<String> STATUS_PAGE_URL = new InstanceInfoField<String>(Name.StatusPageUrl, new Accessor<String>(){

        @Override
        public InstanceInfo.Builder update(InstanceInfo.Builder builder, String value) {
            return builder.withStatusPageUrl(value);
        }

        @Override
        public String getValue(InstanceInfo instanceInfo) {
            return instanceInfo.getStatusPageUrl();
        }
    });
    public static final InstanceInfoField<HashSet<String>> HEALTHCHECK_URLS = new InstanceInfoField<HashSet<String>>(Name.HealthCheckUrls, new Accessor<HashSet<String>>(){

        @Override
        public InstanceInfo.Builder update(InstanceInfo.Builder builder, HashSet<String> value) {
            return builder.withHealthCheckUrls(value);
        }

        @Override
        public HashSet<String> getValue(InstanceInfo instanceInfo) {
            return instanceInfo.getHealthCheckUrls();
        }
    });
    public static final InstanceInfoField<Map<String, String>> META_DATA = new InstanceInfoField<Map<String, String>>(Name.MetaData, new Accessor<Map<String, String>>(){

        @Override
        public InstanceInfo.Builder update(InstanceInfo.Builder builder, Map<String, String> value) {
            return builder.withMetaData(value);
        }

        @Override
        public Map<String, String> getValue(InstanceInfo instanceInfo) {
            return instanceInfo.getMetaData();
        }
    });
    public static final InstanceInfoField<DataCenterInfo> DATA_CENTER_INFO = new InstanceInfoField<DataCenterInfo>(Name.DataCenterInfo, new Accessor<DataCenterInfo>(){

        @Override
        public InstanceInfo.Builder update(InstanceInfo.Builder builder, DataCenterInfo value) {
            return builder.withDataCenterInfo(value);
        }

        @Override
        public DataCenterInfo getValue(InstanceInfo instanceInfo) {
            return instanceInfo.getDataCenterInfo();
        }
    });
    private final Name fieldName;
    private final Accessor<T> accessor;
    private final Type valueType;

    private InstanceInfoField(Name fieldName, Accessor<T> accessor) {
        this.fieldName = fieldName;
        this.accessor = accessor;
        this.valueType = ((ParameterizedType)accessor.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
    }

    InstanceInfo.Builder update(InstanceInfo.Builder builder, T value) {
        this.accessor.update(builder, value);
        return builder;
    }

    public Name getFieldName() {
        return this.fieldName;
    }

    public Type getValueType() {
        return this.valueType;
    }

    public T getValue(InstanceInfo instanceInfo) {
        return this.accessor.getValue(instanceInfo);
    }

    public static <T> InstanceInfoField<T> forName(Name name) {
        switch (name) {
            case AppGroup: {
                return APPLICATION_GROUP;
            }
            case App: {
                return APPLICATION;
            }
            case Asg: {
                return ASG;
            }
            case VipAddress: {
                return VIP_ADDRESS;
            }
            case SecureVipAddress: {
                return SECURE_VIP_ADDRESS;
            }
            case Ports: {
                return PORTS;
            }
            case Status: {
                return STATUS;
            }
            case HomePageUrl: {
                return HOMEPAGE_URL;
            }
            case StatusPageUrl: {
                return STATUS_PAGE_URL;
            }
            case HealthCheckUrls: {
                return HEALTHCHECK_URLS;
            }
            case MetaData: {
                return META_DATA;
            }
            case DataCenterInfo: {
                return DATA_CENTER_INFO;
            }
        }
        throw new IllegalArgumentException("Unhandled name: " + (Object)((Object)name));
    }

    private static interface Accessor<T> {
        public InstanceInfo.Builder update(InstanceInfo.Builder var1, T var2);

        public T getValue(InstanceInfo var1);
    }

    public static enum Name {
        AppGroup,
        App,
        Asg,
        VipAddress,
        SecureVipAddress,
        Ports,
        Status,
        HomePageUrl,
        StatusPageUrl,
        HealthCheckUrls,
        MetaData,
        DataCenterInfo;

        private static final Map<String, Name> nameStrVsName;

        private static void updateNames() {
            for (Name name : Name.values()) {
                nameStrVsName.put(name.name(), name);
            }
        }

        public static Name forName(String name) {
            return nameStrVsName.get(name);
        }

        static {
            nameStrVsName = new HashMap<String, Name>();
            Name.updateNames();
        }
    }
}

