/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.registry.instance;

public class NetworkAddress {
    public static final String PUBLIC_ADDRESS = "public";
    public static final String PRIVATE_ADDRESS = "private";
    private final ProtocolType protocolType;
    private final String label;
    private final String ipAddress;
    private final String hostName;

    protected NetworkAddress() {
        this.protocolType = null;
        this.hostName = null;
        this.ipAddress = null;
        this.label = null;
    }

    public NetworkAddress(String label, ProtocolType protocolType, String ipAddress, String hostName) {
        this.label = label;
        this.protocolType = protocolType;
        this.ipAddress = ipAddress;
        this.hostName = hostName;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean hasLabel(String otherLabel) {
        return this.label.equals(otherLabel);
    }

    public ProtocolType getProtocolType() {
        return this.protocolType;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getHostName() {
        return this.hostName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkAddress address = (NetworkAddress)o;
        if (this.hostName != null ? !this.hostName.equals(address.hostName) : address.hostName != null) {
            return false;
        }
        if (this.ipAddress != null ? !this.ipAddress.equals(address.ipAddress) : address.ipAddress != null) {
            return false;
        }
        if (this.label != null ? !this.label.equals(address.label) : address.label != null) {
            return false;
        }
        return this.protocolType == address.protocolType;
    }

    public int hashCode() {
        int result = this.protocolType != null ? this.protocolType.hashCode() : 0;
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        result = 31 * result + (this.ipAddress != null ? this.ipAddress.hashCode() : 0);
        result = 31 * result + (this.hostName != null ? this.hostName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "NetworkAddress{protocolType=" + (Object)((Object)this.protocolType) + ", label='" + this.label + '\'' + ", ipAddress='" + this.ipAddress + '\'' + ", hostName='" + this.hostName + '\'' + '}';
    }

    public static class NetworkAddressBuilder {
        private ProtocolType protocolType;
        private String label;
        private String ipAddress;
        private String hostName;

        private NetworkAddressBuilder() {
        }

        public static NetworkAddressBuilder aNetworkAddress() {
            return new NetworkAddressBuilder();
        }

        public NetworkAddressBuilder withProtocolType(ProtocolType protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        public NetworkAddressBuilder withLabel(String label) {
            this.label = label;
            return this;
        }

        public NetworkAddressBuilder withIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public NetworkAddressBuilder withHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public NetworkAddressBuilder but() {
            return NetworkAddressBuilder.aNetworkAddress().withProtocolType(this.protocolType).withLabel(this.label).withIpAddress(this.ipAddress).withHostName(this.hostName);
        }

        public NetworkAddress build() {
            return new NetworkAddress(this.label, this.protocolType, this.ipAddress, this.hostName);
        }
    }

    public static enum ProtocolType {
        IPv4,
        IPv6;

    }
}

