/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.registry.selector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class DataSelector<T, S extends DataSelector<T, S>> {
    protected final List<List<Criteria<T, ?>>> queryStack = new ArrayList();
    protected List<Criteria<T, ?>> current = new ArrayList();

    DataSelector() {
        this.queryStack.add(this.current);
    }

    public S any() {
        if (!this.current.isEmpty()) {
            throw new IllegalStateException("Cannot apply any() as there are some criteria in the list");
        }
        return this.or();
    }

    public S or() {
        this.current = new ArrayList();
        this.queryStack.add(this.current);
        return (S)this;
    }

    protected Iterator<T> applyQuery(Iterator<T> endpointIt) {
        final FirstRunIterator firstRunIterator = new FirstRunIterator(endpointIt);
        return new Iterator<T>(){
            public SecondRunIterator secondRunIterator;

            @Override
            public boolean hasNext() {
                if (firstRunIterator.hasNext()) {
                    return true;
                }
                if (DataSelector.this.queryStack.size() < 2) {
                    return false;
                }
                if (this.secondRunIterator == null) {
                    this.secondRunIterator = new SecondRunIterator(firstRunIterator.getAvailableValues());
                }
                return this.secondRunIterator.hasNext();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return firstRunIterator.hasNext() ? firstRunIterator.next() : this.secondRunIterator.next();
                }
                throw new NoSuchElementException("no more elements");
            }

            @Override
            public void remove() {
                throw new IllegalStateException("Operation not supported");
            }
        };
    }

    class SecondRunIterator
    implements Iterator<T> {
        private final List<T>[] bufferedMatchedItems;
        private int replayPosition;
        private Iterator<T> replayPositionIterator = Collections.emptyIterator();

        SecondRunIterator(List<T>[] bufferedMatchedItems) {
            this.bufferedMatchedItems = bufferedMatchedItems;
        }

        @Override
        public boolean hasNext() {
            if (this.replayPosition >= this.bufferedMatchedItems.length) {
                return false;
            }
            if (this.replayPositionIterator.hasNext()) {
                return true;
            }
            ++this.replayPosition;
            while (this.replayPosition < this.bufferedMatchedItems.length) {
                List items = this.bufferedMatchedItems[this.replayPosition];
                if (items != null && !items.isEmpty()) {
                    this.replayPositionIterator = items.iterator();
                    return true;
                }
                ++this.replayPosition;
            }
            return false;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                return this.replayPositionIterator.next();
            }
            throw new NoSuchElementException("no more elements");
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Operation not supported");
        }
    }

    class FirstRunIterator
    implements Iterator<T> {
        private final Iterator<T> endpointIt;
        private final List<T>[] availableValues;
        private T nextValue;

        FirstRunIterator(Iterator<T> endpointIt) {
            this.availableValues = new List[DataSelector.this.queryStack.size()];
            this.endpointIt = endpointIt;
        }

        public List<T>[] getAvailableValues() {
            return this.availableValues;
        }

        @Override
        public boolean hasNext() {
            if (this.nextValue != null) {
                return true;
            }
            while (this.endpointIt.hasNext()) {
                Object candidate = this.endpointIt.next();
                if (this.matches(candidate, DataSelector.this.queryStack.get(0))) {
                    this.nextValue = candidate;
                    return true;
                }
                for (int i = 1; i < DataSelector.this.queryStack.size(); ++i) {
                    if (!this.matches(candidate, DataSelector.this.queryStack.get(i))) continue;
                    List queue = this.availableValues[i];
                    if (queue == null) {
                        queue = new LinkedList();
                        this.availableValues[i] = queue;
                    }
                    queue.add(candidate);
                }
            }
            return false;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                Object toReturn = this.nextValue;
                this.nextValue = null;
                return toReturn;
            }
            throw new NoSuchElementException("no more elements");
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Operation not supported");
        }

        private boolean matches(T candidate, List<Criteria<T, ?>> criterias) {
            for (Criteria criteria : criterias) {
                if (criteria.matches(candidate)) continue;
                return false;
            }
            return true;
        }
    }

    static abstract class Criteria<T, V> {
        private final V[] values;

        @SafeVarargs
        Criteria(V ... values) {
            this.values = values;
        }

        boolean matches(T endpoint) {
            for (V value : this.values) {
                if (!this.matches(value, endpoint)) continue;
                return true;
            }
            return false;
        }

        protected abstract boolean matches(V var1, T var2);
    }
}

