/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.transport;

import com.eureka2.shading.reactivex.netty.pipeline.PipelineConfigurator;
import com.netflix.eureka2.codec.CodecType;
import com.netflix.eureka2.transport.codec.AbstractNettyCodec;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import rx.functions.Func1;

public class EurekaPipelineConfigurator
implements PipelineConfigurator<Object, Object> {
    private static final int MAX_FRAME_LENGTH = 65536;
    private final Func1<CodecType, AbstractNettyCodec> codecBuilder;
    private final CodecType codec;

    public EurekaPipelineConfigurator(Func1<CodecType, AbstractNettyCodec> codecBuilder, CodecType codec) {
        this.codecBuilder = codecBuilder;
        this.codec = codec;
    }

    @Override
    public void configureNewPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(LengthFieldBasedFrameDecoder.class.getSimpleName(), (ChannelHandler)new LengthFieldBasedFrameDecoder(65536, 0, 4, 0, 4));
        pipeline.addLast(LengthFieldPrepender.class.getSimpleName(), (ChannelHandler)new LengthFieldPrepender(4));
        AbstractNettyCodec handler = (AbstractNettyCodec)((Object)this.codecBuilder.call((Object)this.codec));
        pipeline.addLast(((Object)((Object)handler)).getClass().getSimpleName(), (ChannelHandler)handler);
    }
}

