/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.transport.base;

import com.netflix.eureka2.transport.MessageConnection;
import com.netflix.eureka2.utils.ExceptionUtils;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Action0;
import rx.schedulers.Schedulers;

public class SelfClosingConnection
implements MessageConnection {
    private static final Logger logger = LoggerFactory.getLogger(SelfClosingConnection.class);
    private static final SelfClosingException CLOSING_EXCEPTION = ExceptionUtils.trimStackTraceof(new SelfClosingException("Connection self-closing"));
    private final Action0 selfTerminateTask = new Action0(){

        public void call() {
            logger.info("Shutting down the connection after {} seconds", (Object)SelfClosingConnection.this.lifecycleDurationMs);
            SelfClosingConnection.this.shutdown(CLOSING_EXCEPTION);
        }
    };
    private final Random random = new Random();
    private final MessageConnection delegate;
    private final Scheduler.Worker terminationWorker;
    private final long lifecycleDurationMs;

    public SelfClosingConnection(MessageConnection delegate, long lifecycleDurationMs) {
        this(delegate, lifecycleDurationMs, Schedulers.computation());
    }

    public SelfClosingConnection(MessageConnection delegate, long lifecycleDurationMs, Scheduler terminationScheduler) {
        this.delegate = delegate;
        this.lifecycleDurationMs = lifecycleDurationMs;
        this.terminationWorker = terminationScheduler.createWorker();
        if (lifecycleDurationMs > 0L) {
            this.terminationWorker.schedule(this.selfTerminateTask, this.randomizeLifecycleDuration(lifecycleDurationMs), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public Observable<Void> submit(Object message) {
        return this.delegate.submit(message);
    }

    @Override
    public Observable<Void> submitWithAck(Object message) {
        return this.delegate.submitWithAck(message);
    }

    @Override
    public Observable<Void> submitWithAck(Object message, long timeout) {
        return this.delegate.submitWithAck(message, timeout);
    }

    @Override
    public Observable<Void> acknowledge() {
        return this.delegate.acknowledge();
    }

    @Override
    public Observable<Object> incoming() {
        return this.delegate.incoming();
    }

    @Override
    public Observable<Void> onError(Throwable error) {
        return this.delegate.onError(error);
    }

    @Override
    public Observable<Void> onCompleted() {
        return this.delegate.onCompleted();
    }

    @Override
    public void shutdown() {
        this.terminationWorker.unsubscribe();
        this.delegate.shutdown();
    }

    @Override
    public void shutdown(Throwable e) {
        this.terminationWorker.unsubscribe();
        this.delegate.shutdown(e);
    }

    @Override
    public Observable<Void> lifecycleObservable() {
        return this.delegate.lifecycleObservable();
    }

    protected long randomizeLifecycleDuration(long lifecycleDurationMs) {
        long delta = (long)((double)lifecycleDurationMs * (this.random.nextDouble() - 0.5));
        return lifecycleDurationMs + delta;
    }

    public static class SelfClosingException
    extends Exception {
        public SelfClosingException(String msg) {
            super(msg);
        }
    }
}

