/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.transport.codec;

import com.netflix.eureka2.transport.Acknowledgement;
import com.netflix.eureka2.transport.codec.AbstractNettyCodec;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DynamicNettyCodec
extends AbstractNettyCodec {
    private final Set<Class<?>> protocolTypes;
    private final Map<Byte, AbstractNettyCodec> codecMap;
    private volatile AbstractNettyCodec curentCodec;
    private volatile byte currentCodecVersion;

    public DynamicNettyCodec(Set<Class<?>> protocolTypes, Map<Byte, AbstractNettyCodec> codecMap, byte defaultCodecVersion) {
        this.protocolTypes = protocolTypes;
        this.codecMap = codecMap;
        this.currentCodecVersion = defaultCodecVersion;
        this.curentCodec = codecMap.get(defaultCodecVersion);
    }

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return msg instanceof Acknowledgement || this.protocolTypes.contains(msg.getClass());
    }

    @Override
    public void encode(ChannelHandlerContext ctx, Object msg, ByteBuf out) throws Exception {
        if (this.curentCodec == null) {
            throw new IllegalArgumentException("Codec not available for eureka protocol version " + this.currentCodecVersion);
        }
        out.writeByte((int)this.currentCodecVersion);
        this.curentCodec.encode(ctx, msg, out);
    }

    @Override
    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int readableBytes = in.readableBytes();
        if (readableBytes == 0) {
            return;
        }
        this.currentCodecVersion = in.readByte();
        this.curentCodec = this.codecMap.get(this.currentCodecVersion);
        if (this.curentCodec == null) {
            throw new IllegalArgumentException("Codec not available for eureka protocol version " + this.currentCodecVersion);
        }
        this.curentCodec.decode(ctx, in, out);
    }
}

