/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.transport.utils;

import com.eureka2.shading.apache.avro.Protocol;
import com.eureka2.shading.apache.avro.Schema;
import java.io.IOException;
import java.io.InputStream;

public final class AvroUtils {
    private AvroUtils() {
    }

    public static Schema loadSchema(String schemaResource, String envelopeType) {
        Protocol protocol;
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(schemaResource);
        if (stream == null) {
            throw new IllegalArgumentException("missing Avro schema document on classpath: " + schemaResource);
        }
        try {
            protocol = Protocol.parse(stream);
        }
        catch (IOException e) {
            throw new RuntimeException("IO error during loading Avro schema from file " + schemaResource, e);
        }
        return protocol.getType(envelopeType).getFields().get(0).schema();
    }
}

