/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ExtCollections {
    private ExtCollections() {
    }

    public static <T> HashSet<T> asSet(T ... a) {
        HashSet result = new HashSet();
        Collections.addAll(result, a);
        return result;
    }

    public static <T> Iterator<T> singletonIterator(T value) {
        return Collections.singletonList(value).iterator();
    }

    @SafeVarargs
    public static <T> Iterator<T> concat(final Iterator<T> ... iterators) {
        return new Iterator<T>(){
            private int current;
            private T next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                if (this.current >= iterators.length) {
                    return false;
                }
                while (this.current < iterators.length) {
                    if (iterators[this.current].hasNext()) {
                        this.next = iterators[this.current].next();
                        return true;
                    }
                    ++this.current;
                }
                return false;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    Object result = this.next;
                    this.next = null;
                    return result;
                }
                throw new NoSuchElementException("no more elements");
            }

            @Override
            public void remove() {
                throw new IllegalStateException("operation not supported");
            }
        };
    }
}

