/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.utils;

import com.eureka2.shading.codehaus.jackson.annotate.JsonAutoDetect;
import com.eureka2.shading.codehaus.jackson.annotate.JsonMethod;
import com.eureka2.shading.codehaus.jackson.map.ObjectMapper;
import com.eureka2.shading.codehaus.jackson.map.SerializationConfig;
import com.eureka2.shading.codehaus.jackson.map.annotate.JsonSerialize;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Json {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private Json() {
    }

    public static ObjectMapper getMapper() {
        return MAPPER;
    }

    public static <T> T fromJson(byte[] byteBuf, Class<T> type) {
        try {
            return MAPPER.readValue(byteBuf, type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Provided buffer does not contain JSON object conforming to type " + type.getName(), e);
        }
    }

    public static <T> T fromJson(ByteBuf byteBuf, Class<T> type) {
        try {
            return MAPPER.readValue((InputStream)new ByteBufInputStream(byteBuf), type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Provided buffer does not contain JSON object conforming to type " + type.getName(), e);
        }
    }

    public static <T> byte[] toByteArrayJson(T value) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            MAPPER.writeValue(out, value);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Value of type " + value.getClass().getName() + " could not be serialized into JSON", e);
        }
    }

    public static <T> ByteBuf toByteBufJson(T value) {
        try {
            ByteBuf byteBuf = UnpooledByteBufAllocator.DEFAULT.buffer();
            MAPPER.writeValue((OutputStream)new ByteBufOutputStream(byteBuf), value);
            return byteBuf;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Value of type " + value.getClass().getName() + " could not be serialized into JSON", e);
        }
    }

    static {
        MAPPER.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        MAPPER.setVisibility(JsonMethod.GETTER, JsonAutoDetect.Visibility.NONE);
        MAPPER.setVisibility(JsonMethod.IS_GETTER, JsonAutoDetect.Visibility.NONE);
        MAPPER.setVisibility(JsonMethod.SETTER, JsonAutoDetect.Visibility.NONE);
        MAPPER.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }
}

