/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.utils;

import com.netflix.eureka2.metric.SerializedTaskInvokerMetrics;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.exceptions.OnErrorNotImplementedException;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public abstract class SerializedTaskInvoker {
    private static final Logger logger = LoggerFactory.getLogger(SerializedTaskInvoker.class);
    private static final Exception TASK_CANCELLED = new CancellationException("Task cancelled");
    private final AtomicInteger queueSize;
    private final SerializedTaskInvokerMetrics metrics;
    private final Scheduler.Worker worker;
    private final ConcurrentLinkedDeque<InvokerTask<?, ?>> taskQueue = new ConcurrentLinkedDeque();
    private final AtomicBoolean executorScheduled = new AtomicBoolean();
    private final Action0 executeAction = new Action0(){

        public void call() {
            SerializedTaskInvoker.this.executorScheduled.set(false);
            while (!SerializedTaskInvoker.this.taskQueue.isEmpty()) {
                InvokerTask task = (InvokerTask)SerializedTaskInvoker.this.taskQueue.poll();
                if (task.execute()) {
                    SerializedTaskInvoker.this.metrics.incrementOutputSuccess();
                } else {
                    task.cancel();
                    SerializedTaskInvoker.this.metrics.incrementOutputFailure();
                }
                SerializedTaskInvoker.this.queueSize.getAndDecrement();
                SerializedTaskInvoker.this.metrics.setQueueSize(SerializedTaskInvoker.this.queueSize.get());
            }
        }
    };

    protected SerializedTaskInvoker(SerializedTaskInvokerMetrics metrics) {
        this(metrics, Schedulers.computation());
    }

    protected SerializedTaskInvoker(SerializedTaskInvokerMetrics metrics, Scheduler scheduler) {
        this.worker = scheduler.createWorker();
        this.queueSize = new AtomicInteger(0);
        this.metrics = metrics;
    }

    protected Observable<Void> submitForAck(final Callable<Observable<Void>> task) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Void>(){

            public void call(Subscriber<? super Void> subscriber) {
                SerializedTaskInvoker.this.addAndSchedule(new InvokerTaskWithAck(task, subscriber));
            }
        });
    }

    protected <T> Observable<T> submitForResult(final Callable<Observable<T>> task) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Observable<T>>(){

            public void call(Subscriber<? super Observable<T>> subscriber) {
                SerializedTaskInvoker.this.addAndSchedule(new InvokerTaskWithResult(task, subscriber));
            }
        }).switchMap(new Func1<Observable<T>, Observable<? extends T>>(){

            public Observable<? extends T> call(Observable<T> tObservable) {
                return tObservable;
            }
        });
    }

    private void addAndSchedule(InvokerTask<?, ?> invokerTask) {
        boolean success = this.taskQueue.add(invokerTask);
        if (success) {
            this.queueSize.incrementAndGet();
            this.metrics.incrementInputSuccess();
            this.metrics.setQueueSize(this.queueSize.get());
        } else {
            this.metrics.incrementInputFailure();
        }
        if (this.executorScheduled.compareAndSet(false, true)) {
            this.worker.schedule(this.executeAction);
        }
    }

    protected void shutdown() {
        this.worker.unsubscribe();
        while (!this.taskQueue.isEmpty()) {
            this.taskQueue.poll().cancel();
        }
        this.metrics.setQueueSize(0);
    }

    private static class InvokerTaskWithResult<T>
    extends InvokerTask<T, Observable<T>> {
        private InvokerTaskWithResult(Callable<Observable<T>> actual, Subscriber<? super Observable<T>> subscriberForThisTask) {
            super(actual, subscriberForThisTask);
        }

        @Override
        protected boolean execute() {
            try {
                this.subscriberForThisTask.onNext(this.actual.call());
                this.subscriberForThisTask.onCompleted();
            }
            catch (Throwable e) {
                logger.error("Exception invoking the InvokerTaskWithResult task.", e);
                this.subscriberForThisTask.onError(e);
                return false;
            }
            return true;
        }

        public String toString() {
            return this.actual.toString();
        }
    }

    private static class InvokerTaskWithAck
    extends InvokerTask<Void, Void> {
        private InvokerTaskWithAck(Callable<Observable<Void>> actual, Subscriber<? super Void> subscriberForThisTask) {
            super(actual, subscriberForThisTask);
        }

        @Override
        protected boolean execute() {
            try {
                ((Observable)this.actual.call()).subscribe((Subscriber)new Subscriber<Void>(){

                    public void onCompleted() {
                        InvokerTaskWithAck.this.subscriberForThisTask.onCompleted();
                    }

                    public void onError(Throwable e) {
                        InvokerTaskWithAck.this.subscriberForThisTask.onError(e);
                    }

                    public void onNext(Void aVoid) {
                    }
                });
            }
            catch (Throwable e) {
                logger.error("Exception invoking the InvokerTaskWithAck task: {}", (Object)this.actual, (Object)e);
                this.subscriberForThisTask.onError(e);
                return false;
            }
            return true;
        }

        public String toString() {
            return this.actual.toString();
        }
    }

    private static abstract class InvokerTask<T, R> {
        protected final Callable<Observable<T>> actual;
        protected final Subscriber<? super R> subscriberForThisTask;

        private InvokerTask(Callable<Observable<T>> actual, Subscriber<? super R> subscriberForThisTask) {
            this.actual = actual;
            this.subscriberForThisTask = subscriberForThisTask;
        }

        protected abstract boolean execute();

        protected void cancel() {
            logger.info("Cancelling task {}", (Object)this.toString());
            try {
                this.subscriberForThisTask.onError((Throwable)TASK_CANCELLED);
            }
            catch (OnErrorNotImplementedException e) {
                logger.error("Error sending onError to task subscriber", (Throwable)e);
            }
        }
    }
}

