/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.utils;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public final class SystemUtil {
    public static final String IP4_LOOPBACK = "127.0.0.1";
    public static final String IP6_LOOPBACK = "0:0:0:0:0:0:0:1";

    private SystemUtil() {
    }

    public static String getHostName() {
        try {
            int len;
            Process process = Runtime.getRuntime().exec("hostname");
            InputStream input = process.getInputStream();
            StringBuilder sb = new StringBuilder();
            byte[] bytes = new byte[256];
            while ((len = input.read(bytes)) != -1) {
                sb.append(new String(bytes, 0, len, Charset.defaultCharset()));
            }
            if (process.exitValue() == 0) {
                return sb.toString().trim();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("cannot resolve local host name", e);
        }
    }

    public static boolean isPublic(String ip) {
        return !SystemUtil.isPrivate(ip) && !SystemUtil.isLoopbackIP(ip);
    }

    public static boolean isPrivate(String ip) {
        return (ip.startsWith("10.") || ip.startsWith("172.16.") || ip.startsWith("192.168.") || ip.startsWith("fe80:")) && !SystemUtil.isLoopbackIP(ip);
    }

    public static boolean isLoopbackIP(String ip) {
        return ip.equals(IP4_LOOPBACK) || ip.equals(IP6_LOOPBACK);
    }

    public static boolean isIPv6(String ip) {
        return ip.indexOf(58) != -1;
    }

    public static List<String> getLocalIPs() {
        ArrayList<String> addresses = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface nic = nics.nextElement();
                Enumeration<InetAddress> inetAddresses = nic.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress address = inetAddresses.nextElement();
                    addresses.add(address.getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            throw new RuntimeException("Cannot resolve local network addresses", e);
        }
        return addresses;
    }

    public static List<String> getPublicIPs() {
        ArrayList<String> publicIPs = new ArrayList<String>();
        for (String ip : SystemUtil.getLocalIPs()) {
            if (!SystemUtil.isPublic(ip)) continue;
            publicIPs.add(ip);
        }
        return publicIPs;
    }

    public static List<String> getPrivateIPs() {
        ArrayList<String> privateIPs = new ArrayList<String>();
        for (String ip : SystemUtil.getLocalIPs()) {
            if (!SystemUtil.isPrivate(ip)) continue;
            privateIPs.add(ip);
        }
        return privateIPs;
    }

    public static void main(String[] args) {
        System.out.println("Hostname: " + SystemUtil.getHostName());
        System.out.println("Public IPs: " + SystemUtil.getPublicIPs());
        System.out.println("Private IPs: " + SystemUtil.getPrivateIPs());
    }
}

