/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.utils.rx;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Subscriber;
import rx.subjects.AsyncSubject;
import rx.subjects.Subject;

public class BreakerSwitchOperator<T>
implements Observable.Operator<T, T> {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Subject<Void, Void> onCompleteFuture = AsyncSubject.create();

    public Subscriber<? super T> call(Subscriber<? super T> subscriber) {
        return new BreakerSwitchSubscriber<T>(subscriber, (Observable<Void>)this.onCompleteFuture);
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.onCompleteFuture.onCompleted();
        }
    }

    private static class BreakerSwitchSubscriber<T>
    extends Subscriber<T> {
        private final Subscriber<T> actual;

        public BreakerSwitchSubscriber(Subscriber<T> actual, Observable<Void> onCompleteFuture) {
            super(actual);
            this.actual = actual;
            onCompleteFuture.subscribe((Subscriber)new Subscriber<Void>(){

                public void onCompleted() {
                    BreakerSwitchSubscriber.this.unsubscribe();
                    BreakerSwitchSubscriber.this.onCompleted();
                }

                public void onError(Throwable e) {
                }

                public void onNext(Void aVoid) {
                }
            });
        }

        public void onCompleted() {
            this.actual.onCompleted();
        }

        public void onError(Throwable e) {
            this.actual.onError(e);
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }
    }
}

