/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.utils.rx;

import com.netflix.eureka2.utils.rx.BreakerSwitchOperator;
import rx.Observable;
import rx.Subscriber;
import rx.observers.SafeSubscriber;
import rx.subjects.Subject;

public class BreakerSwitchSubject<T>
extends Subject<T, T> {
    private final Subject<T, T> delegate;
    private final BreakerSwitchOperator<T> breaker;

    protected BreakerSwitchSubject(Observable.OnSubscribe<T> onSubscribe, Subject<T, T> delegate, BreakerSwitchOperator<T> breaker) {
        super(onSubscribe);
        this.delegate = delegate;
        this.breaker = breaker;
    }

    public boolean hasObservers() {
        return this.delegate.hasObservers();
    }

    public void onCompleted() {
        this.delegate.onCompleted();
    }

    public void onError(Throwable e) {
        this.delegate.onError(e);
    }

    public void onNext(T t) {
        this.delegate.onNext(t);
    }

    public void close() {
        this.breaker.close();
    }

    public static <T> BreakerSwitchSubject<T> create(final Subject<T, T> delegate) {
        final BreakerSwitchOperator breaker = new BreakerSwitchOperator();
        return new BreakerSwitchSubject<T>(new Observable.OnSubscribe<T>(){

            public void call(Subscriber<? super T> subscriber) {
                delegate.lift((Observable.Operator)breaker).subscribe((Subscriber)new SafeSubscriber(subscriber));
            }
        }, delegate, breaker);
    }
}

