/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.utils.rx;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;
import rx.observers.SafeSubscriber;
import rx.subjects.PublishSubject;
import rx.subjects.Subject;

public class PauseableSubject<T>
extends Subject<T, T> {
    private static final Logger logger = LoggerFactory.getLogger(PauseableSubject.class);
    private final AtomicInteger resumeState = new AtomicInteger(ResumeState.NotPaused.ordinal());
    private final AtomicBoolean paused;
    private final Subject<T, T> notificationSubject;
    private final NotificationsSubjectSubscriber subscriber = new NotificationsSubjectSubscriber();
    private final ConcurrentLinkedQueue<T> notificationsWhenPaused;
    private volatile boolean completedWhenPaused;
    private volatile Throwable errorWhenPaused;

    protected PauseableSubject(Observable.OnSubscribe<T> onSubscribe, Subject<T, T> notificationSubject) {
        super(onSubscribe);
        this.notificationSubject = notificationSubject;
        this.notificationsWhenPaused = new ConcurrentLinkedQueue();
        this.paused = new AtomicBoolean();
    }

    public static <T> PauseableSubject<T> create() {
        PublishSubject notificationSubject = PublishSubject.create();
        return new PauseableSubject<T>(new Observable.OnSubscribe<T>((Subject)notificationSubject){
            final /* synthetic */ Subject val$notificationSubject;
            {
                this.val$notificationSubject = subject;
            }

            public void call(Subscriber<? super T> subscriber) {
                this.val$notificationSubject.subscribe(subscriber);
            }
        }, notificationSubject);
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    public void pause() {
        this.paused.set(true);
    }

    public boolean hasObservers() {
        return this.notificationSubject.hasObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResumeResult resume() {
        if (this.isPaused()) {
            if (this.resumeState.compareAndSet(ResumeState.NotPaused.ordinal(), ResumeState.Resuming.ordinal())) {
                try {
                    this.drainBuffer();
                    this.paused.set(false);
                    if (this.completedWhenPaused) {
                        this.onCompleted();
                    } else if (null != this.errorWhenPaused) {
                        this.onError(this.errorWhenPaused);
                    }
                    ResumeResult resumeResult = ResumeResult.Resumed;
                    return resumeResult;
                }
                catch (Exception e) {
                    logger.error("Error while resuming notifications subject.", (Throwable)e);
                    this.resumeState.compareAndSet(ResumeState.Resuming.ordinal(), ResumeState.Error.ordinal());
                    this.onError(e);
                    ResumeResult resumeResult = ResumeResult.Resumed;
                    return resumeResult;
                }
                finally {
                    this.resumeState.compareAndSet(ResumeState.Resuming.ordinal(), ResumeState.NotPaused.ordinal());
                }
            }
            return ResumeResult.DuplicateResume;
        }
        return ResumeResult.NotPaused;
    }

    private void drainBuffer() {
        T nextPolled;
        while ((nextPolled = this.notificationsWhenPaused.poll()) != null) {
            this.notificationSubject.onNext(nextPolled);
        }
    }

    public void onCompleted() {
        this.subscriber.onCompleted();
    }

    public void onError(Throwable e) {
        this.subscriber.onError(e);
    }

    public void onNext(T next) {
        this.subscriber.onNext(next);
    }

    private class NotificationsSubjectSubscriber
    extends SafeSubscriber<T> {
        public NotificationsSubjectSubscriber() {
            super(new Subscriber<T>(){

                public void onCompleted() {
                    if (PauseableSubject.this.paused.get()) {
                        PauseableSubject.this.completedWhenPaused = true;
                    } else {
                        PauseableSubject.this.notificationSubject.onCompleted();
                    }
                }

                public void onError(Throwable e) {
                    if (PauseableSubject.this.paused.get()) {
                        PauseableSubject.this.errorWhenPaused = e;
                    } else {
                        PauseableSubject.this.notificationSubject.onError(e);
                    }
                }

                public void onNext(T notification) {
                    if (PauseableSubject.this.paused.get()) {
                        PauseableSubject.this.notificationsWhenPaused.add(notification);
                    } else {
                        PauseableSubject.this.drainBuffer();
                        PauseableSubject.this.notificationSubject.onNext(notification);
                    }
                }
            });
        }
    }

    private static enum ResumeState {
        NotPaused,
        Resuming,
        Error;

    }

    public static enum ResumeResult {
        NotPaused,
        DuplicateResume,
        Resumed;

    }
}

