/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.utils.rx;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.schedulers.Schedulers;
import rx.subjects.PublishSubject;

public class ResourceObservable<T> {
    private static final Logger logger = LoggerFactory.getLogger(ResourceObservable.class);
    private final ResourceLoader<T> loader;
    private final Scheduler scheduler;
    private final long refreshInterval;
    private final long idleTimeout;
    private final TimeUnit timeUnit;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile ResourceLoaderExecutor executor;
    private final AtomicInteger subscriptionCounter = new AtomicInteger();
    private final Observable<T> observable;

    public ResourceObservable(ResourceLoader<T> loader, Scheduler scheduler, long refreshInterval, long idleTimeout, TimeUnit timeUnit) {
        this.loader = loader;
        this.scheduler = scheduler;
        this.refreshInterval = refreshInterval;
        this.idleTimeout = idleTimeout;
        this.timeUnit = timeUnit;
        this.observable = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call(Subscriber<? super T> subscriber) {
                ResourceObservable.this.lock.lock();
                try {
                    if (ResourceObservable.this.executor == null) {
                        ResourceObservable.this.executor = new ResourceLoaderExecutor();
                        ResourceObservable.this.executor.call();
                    }
                    ResourceObservable.this.subscriptionCounter.incrementAndGet();
                    for (Object entry : ResourceObservable.this.executor.getDataSnapshot()) {
                        subscriber.onNext(entry);
                    }
                    ResourceObservable.this.executor.getDataUpdates().subscribe(subscriber);
                }
                finally {
                    ResourceObservable.this.lock.unlock();
                }
                subscriber.add(new Subscription(){

                    public void unsubscribe() {
                        if (ResourceObservable.this.subscriptionCounter.decrementAndGet() == 0) {
                            ResourceObservable.this.scheduleCleanupTask();
                        }
                    }

                    public boolean isUnsubscribed() {
                        return false;
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleCleanupTask() {
        if (this.idleTimeout <= 0L) {
            return;
        }
        Scheduler.Worker worker = this.scheduler.createWorker();
        try {
            worker.schedule(new Action0(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void call() {
                    ResourceObservable.this.lock.lock();
                    try {
                        if (ResourceObservable.this.subscriptionCounter.get() == 0 && ResourceObservable.this.executor != null) {
                            ResourceObservable.this.executor.cancel();
                            ResourceObservable.this.executor = null;
                        }
                    }
                    finally {
                        ResourceObservable.this.lock.unlock();
                    }
                }
            }, this.idleTimeout, this.timeUnit);
        }
        finally {
            worker.unsubscribe();
        }
    }

    public Observable<T> getObservable() {
        return this.observable;
    }

    public static <T> Observable<T> fromResource(ResourceLoader<T> loader) {
        return new ResourceObservable<T>(loader, Schedulers.io(), -1L, -1L, TimeUnit.MILLISECONDS).getObservable();
    }

    public static <T> Observable<T> fromResource(ResourceLoader<T> loader, long refreshInterval, TimeUnit timeUnit) {
        return new ResourceObservable<T>(loader, Schedulers.io(), refreshInterval, -1L, timeUnit).getObservable();
    }

    public static <T> Observable<T> fromResource(ResourceLoader<T> loader, long refreshInterval, long idleTimeout, TimeUnit timeUnit) {
        return new ResourceObservable<T>(loader, Schedulers.io(), refreshInterval, idleTimeout, timeUnit).getObservable();
    }

    public static <T> Observable<T> fromResource(ResourceLoader<T> loader, long refreshInterval, long idleTimeout, TimeUnit timeUnit, Scheduler scheduler) {
        return new ResourceObservable<T>(loader, scheduler, refreshInterval, idleTimeout, timeUnit).getObservable();
    }

    class ResourceLoaderExecutor
    implements Action0 {
        private final Scheduler.Worker worker;
        private volatile Set<T> internalSnapshot;
        private volatile List<T> dataSnapshot;
        private final PublishSubject<T> dataUpdates;
        private volatile boolean terminate;
        private Subscription rescheduleSubscription;

        ResourceLoaderExecutor() {
            this.worker = ResourceObservable.this.scheduler.createWorker();
            this.internalSnapshot = new HashSet();
            this.dataSnapshot = new ArrayList();
            this.dataUpdates = PublishSubject.create();
        }

        public List<T> getDataSnapshot() {
            return this.dataSnapshot;
        }

        public PublishSubject<T> getDataUpdates() {
            return this.dataUpdates;
        }

        void reschedule() {
            if (!this.terminate && ResourceObservable.this.refreshInterval > 0L) {
                this.rescheduleSubscription = this.worker.schedule((Action0)this, ResourceObservable.this.refreshInterval, ResourceObservable.this.timeUnit);
            }
        }

        void cancel() {
            this.terminate = true;
            this.rescheduleSubscription.unsubscribe();
            this.worker.unsubscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void call() {
            ResourceUpdate update;
            if (this.terminate) {
                return;
            }
            try {
                update = ResourceObservable.this.loader.reload(this.internalSnapshot);
            }
            catch (Exception e) {
                if (e instanceof ResourceLoaderException && ((ResourceLoaderException)e).isRecoverable()) {
                    logger.warn("Recoverable resource loader exception; rescheduling action", (Throwable)e);
                    this.reschedule();
                    return;
                }
                logger.error("Non recoverable resource loader exception; no more actions will be triggered", (Throwable)e);
                this.dataUpdates.onError((Throwable)e);
                return;
            }
            ResourceObservable.this.lock.lock();
            try {
                for (Object entry : update.getCancelled()) {
                    this.dataUpdates.onNext(entry);
                }
                for (Object entry : update.getAdded()) {
                    if (this.internalSnapshot.contains(entry)) continue;
                    this.dataUpdates.onNext(entry);
                }
                this.internalSnapshot = update.getAdded();
                this.dataSnapshot = new ArrayList(update.added);
                if (update.getFinalSentinel() != null) {
                    this.dataSnapshot.add(update.getFinalSentinel());
                }
            }
            finally {
                ResourceObservable.this.lock.unlock();
            }
            this.reschedule();
        }
    }

    public static class ResourceLoaderException
    extends RuntimeException {
        private final boolean recoverable;

        public ResourceLoaderException(String message, boolean recoverable, Throwable cause) {
            super(message, cause);
            this.recoverable = recoverable;
        }

        public boolean isRecoverable() {
            return this.recoverable;
        }
    }

    public static interface ResourceLoader<T> {
        public ResourceUpdate<T> reload(Set<T> var1);
    }

    public static class ResourceUpdate<T> {
        private final Set<T> added;
        private final Set<T> cancelled;
        private final T finalSentinal;

        public ResourceUpdate(Set<T> added, Set<T> cancelled) {
            this(added, cancelled, null);
        }

        public ResourceUpdate(Set<T> added, Set<T> cancelled, T finalSentinel) {
            this.added = added;
            this.cancelled = cancelled;
            this.finalSentinal = finalSentinel;
        }

        public Set<T> getAdded() {
            return this.added;
        }

        public Set<T> getCancelled() {
            return this.cancelled;
        }

        public T getFinalSentinel() {
            return this.finalSentinal;
        }
    }
}

