/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Types;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class Util {
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String ENCODING_GZIP = "gzip";
    public static final String ENCODING_DEFLATE = "deflate";
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final int BUF_SIZE = 2048;

    private Util() {
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static <T> T checkNotNull(T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new NullPointerException(String.format(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    public static void checkState(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalStateException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static String emptyToNull(String string) {
        return string == null || string.isEmpty() ? null : string;
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable, Class<T> type) {
        ArrayList<T> collection;
        if (iterable instanceof Collection) {
            collection = (ArrayList<T>)iterable;
        } else {
            collection = new ArrayList<T>();
            for (T element : iterable) {
                collection.add(element);
            }
        }
        Object[] array = (Object[])Array.newInstance(type, collection.size());
        return collection.toArray(array);
    }

    public static <T> Collection<T> valuesOrEmpty(Map<String, Collection<T>> map, String key) {
        return map.containsKey(key) && map.get(key) != null ? map.get(key) : Collections.emptyList();
    }

    public static void ensureClosed(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static Type resolveLastTypeParameter(Type genericContext, Class<?> supertype) throws IllegalStateException {
        Type resolvedSuperType = Types.getSupertype(genericContext, Types.getRawType(genericContext), supertype);
        Util.checkState(resolvedSuperType instanceof ParameterizedType, "could not resolve %s into a parameterized type %s", genericContext, supertype);
        Type[] types = ((ParameterizedType)ParameterizedType.class.cast(resolvedSuperType)).getActualTypeArguments();
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            if (!(type instanceof WildcardType)) continue;
            types[i] = ((WildcardType)type).getUpperBounds()[0];
        }
        return types[types.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Reader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        try {
            StringBuilder to = new StringBuilder();
            CharBuffer buf = CharBuffer.allocate(2048);
            while (reader.read(buf) != -1) {
                buf.flip();
                to.append(buf);
                buf.clear();
            }
            String string = to.toString();
            return string;
        }
        finally {
            Util.ensureClosed(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream in) throws IOException {
        Util.checkNotNull(in, "in", new Object[0]);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Util.copy(in, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            Util.ensureClosed(in);
        }
    }

    private static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        Util.checkNotNull(from, "from", new Object[0]);
        Util.checkNotNull(to, "to", new Object[0]);
        byte[] buf = new byte[2048];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    static String decodeOrDefault(byte[] data, Charset charset, String defaultValue) {
        if (data == null) {
            return defaultValue;
        }
        Util.checkNotNull(charset, "charset", new Object[0]);
        try {
            return charset.newDecoder().decode(ByteBuffer.wrap(data)).toString();
        }
        catch (CharacterCodingException ex) {
            return defaultValue;
        }
    }
}

