/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Util;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Response
implements Closeable {
    private final int status;
    private final String reason;
    private final Map<String, Collection<String>> headers;
    private final Body body;

    private Response(int status, String reason, Map<String, Collection<String>> headers, Body body) {
        Util.checkState(status >= 200, "Invalid status code: %s", status);
        this.status = status;
        this.reason = reason;
        LinkedHashMap<String, Collection<String>> copyOf = new LinkedHashMap<String, Collection<String>>();
        copyOf.putAll(Util.checkNotNull(headers, "headers", new Object[0]));
        this.headers = Collections.unmodifiableMap(copyOf);
        this.body = body;
    }

    public static Response create(int status, String reason, Map<String, Collection<String>> headers, InputStream inputStream, Integer length) {
        return new Response(status, reason, headers, InputStreamBody.orNull(inputStream, length));
    }

    public static Response create(int status, String reason, Map<String, Collection<String>> headers, byte[] data) {
        return new Response(status, reason, headers, ByteArrayBody.orNull(data));
    }

    public static Response create(int status, String reason, Map<String, Collection<String>> headers, String text, Charset charset) {
        return new Response(status, reason, headers, ByteArrayBody.orNull(text, charset));
    }

    public static Response create(int status, String reason, Map<String, Collection<String>> headers, Body body) {
        return new Response(status, reason, headers, body);
    }

    public int status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public Map<String, Collection<String>> headers() {
        return this.headers;
    }

    public Body body() {
        return this.body;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("HTTP/1.1 ").append(this.status);
        if (this.reason != null) {
            builder.append(' ').append(this.reason);
        }
        builder.append('\n');
        for (String field : this.headers.keySet()) {
            for (String value : Util.valuesOrEmpty(this.headers, field)) {
                builder.append(field).append(": ").append(value).append('\n');
            }
        }
        if (this.body != null) {
            builder.append('\n').append(this.body);
        }
        return builder.toString();
    }

    @Override
    public void close() {
        Util.ensureClosed(this.body);
    }

    private static final class ByteArrayBody
    implements Body {
        private final byte[] data;

        public ByteArrayBody(byte[] data) {
            this.data = data;
        }

        private static Body orNull(byte[] data) {
            if (data == null) {
                return null;
            }
            return new ByteArrayBody(data);
        }

        private static Body orNull(String text, Charset charset) {
            if (text == null) {
                return null;
            }
            Util.checkNotNull(charset, "charset", new Object[0]);
            return new ByteArrayBody(text.getBytes(charset));
        }

        @Override
        public Integer length() {
            return this.data.length;
        }

        @Override
        public boolean isRepeatable() {
            return true;
        }

        @Override
        public InputStream asInputStream() throws IOException {
            return new ByteArrayInputStream(this.data);
        }

        @Override
        public Reader asReader() throws IOException {
            return new InputStreamReader(this.asInputStream(), Util.UTF_8);
        }

        @Override
        public void close() throws IOException {
        }

        public String toString() {
            return Util.decodeOrDefault(this.data, Util.UTF_8, "Binary data");
        }
    }

    private static final class InputStreamBody
    implements Body {
        private final InputStream inputStream;
        private final Integer length;

        private InputStreamBody(InputStream inputStream, Integer length) {
            this.inputStream = inputStream;
            this.length = length;
        }

        private static Body orNull(InputStream inputStream, Integer length) {
            if (inputStream == null) {
                return null;
            }
            return new InputStreamBody(inputStream, length);
        }

        @Override
        public Integer length() {
            return this.length;
        }

        @Override
        public boolean isRepeatable() {
            return false;
        }

        @Override
        public InputStream asInputStream() throws IOException {
            return this.inputStream;
        }

        @Override
        public Reader asReader() throws IOException {
            return new InputStreamReader(this.inputStream, Util.UTF_8);
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }
    }

    public static interface Body
    extends Closeable {
        public Integer length();

        public boolean isRepeatable();

        public InputStream asInputStream() throws IOException;

        public Reader asReader() throws IOException;
    }
}

